/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.encoding;

import io.undertow.server.ConduitWrapper;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.encoding.EncodingMapping;
import io.undertow.util.AttachmentKey;
import io.undertow.util.ConduitFactory;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import java.util.List;
import org.xnio.conduits.StreamSinkConduit;

public class AllowedContentEncodings
implements ConduitWrapper<StreamSinkConduit> {
    public static final AttachmentKey<AllowedContentEncodings> ATTACHMENT_KEY = AttachmentKey.create(AllowedContentEncodings.class);
    private final HttpServerExchange exchange;
    private final List<EncodingMapping> encodings;

    public AllowedContentEncodings(HttpServerExchange exchange2, List<EncodingMapping> encodings) {
        this.exchange = exchange2;
        this.encodings = encodings;
    }

    public String getCurrentContentEncoding() {
        for (EncodingMapping encoding : this.encodings) {
            if (encoding.getAllowed() != null && !encoding.getAllowed().resolve(this.exchange)) continue;
            return encoding.getName();
        }
        return Headers.IDENTITY.toString();
    }

    public EncodingMapping getEncoding() {
        for (EncodingMapping encoding : this.encodings) {
            if (encoding.getAllowed() != null && !encoding.getAllowed().resolve(this.exchange)) continue;
            return encoding;
        }
        return null;
    }

    public boolean isIdentity() {
        return this.getCurrentContentEncoding().equals(Headers.IDENTITY.toString());
    }

    public boolean isNoEncodingsAllowed() {
        return this.encodings.isEmpty();
    }

    @Override
    public StreamSinkConduit wrap(ConduitFactory<StreamSinkConduit> factory, HttpServerExchange exchange2) {
        EncodingMapping encoding;
        if (exchange2.getResponseHeaders().contains(Headers.CONTENT_ENCODING)) {
            return factory.create();
        }
        if (exchange2.getResponseContentLength() != 0L && exchange2.getStatusCode() != 204 && exchange2.getStatusCode() != 304 && (encoding = this.getEncoding()) != null) {
            exchange2.getResponseHeaders().put(Headers.CONTENT_ENCODING, encoding.getName());
            if (exchange2.getRequestMethod().equals(Methods.HEAD)) {
                return factory.create();
            }
            return encoding.getEncoding().getResponseWrapper().wrap(factory, exchange2);
        }
        return factory.create();
    }
}

