/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.encoding;

import io.undertow.UndertowLogger;
import io.undertow.conduits.DeflatingStreamSinkConduit;
import io.undertow.server.ConduitWrapper;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.encoding.ContentEncodingProvider;
import io.undertow.util.ConduitFactory;
import io.undertow.util.ObjectPool;
import java.util.zip.Deflater;
import org.xnio.conduits.StreamSinkConduit;

public class DeflateEncodingProvider
implements ContentEncodingProvider {
    private final ObjectPool<Deflater> deflaterPool;

    public DeflateEncodingProvider() {
        this(8);
    }

    public DeflateEncodingProvider(int deflateLevel) {
        this(DeflatingStreamSinkConduit.newInstanceDeflaterPool(deflateLevel));
    }

    public DeflateEncodingProvider(ObjectPool<Deflater> deflaterPool) {
        this.deflaterPool = deflaterPool;
    }

    @Override
    public ConduitWrapper<StreamSinkConduit> getResponseWrapper() {
        return new ConduitWrapper<StreamSinkConduit>(){

            @Override
            public StreamSinkConduit wrap(ConduitFactory<StreamSinkConduit> factory, HttpServerExchange exchange2) {
                UndertowLogger.REQUEST_LOGGER.tracef("Created DEFLATE response conduit for %s", (Object)exchange2);
                return new DeflatingStreamSinkConduit(factory, exchange2, DeflateEncodingProvider.this.deflaterPool);
            }
        };
    }
}

