/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.attribute;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeBuilder;
import io.undertow.attribute.ReadOnlyAttributeException;
import io.undertow.attribute.RequestURLAttribute;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletRequestContext;

public class ServletRequestURLAttribute
implements ExchangeAttribute {
    public static final String REQUEST_URL_SHORT = "%U";
    public static final String REQUEST_URL = "%{REQUEST_URL}";
    public static final ExchangeAttribute INSTANCE = new ServletRequestURLAttribute();

    private ServletRequestURLAttribute() {
    }

    @Override
    public String readAttribute(HttpServerExchange exchange2) {
        ServletRequestContext src = exchange2.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        if (src == null) {
            return RequestURLAttribute.INSTANCE.readAttribute(exchange2);
        }
        String uri = (String)src.getServletRequest().getAttribute("jakarta.servlet.forward.request_uri");
        if (uri != null) {
            return uri;
        }
        uri = (String)src.getServletRequest().getAttribute("jakarta.servlet.error.request_uri");
        if (uri != null) {
            return uri;
        }
        return RequestURLAttribute.INSTANCE.readAttribute(exchange2);
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange2, String newValue) throws ReadOnlyAttributeException {
        RequestURLAttribute.INSTANCE.writeAttribute(exchange2, newValue);
    }

    public String toString() {
        return REQUEST_URL;
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Request URL";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.equals(ServletRequestURLAttribute.REQUEST_URL) || token.equals(ServletRequestURLAttribute.REQUEST_URL_SHORT)) {
                return INSTANCE;
            }
            return null;
        }

        @Override
        public int priority() {
            return 1;
        }
    }
}

