/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.attribute;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeBuilder;
import io.undertow.attribute.ReadOnlyAttributeException;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletRequestContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;

public class ServletRequestedSessionIdAttribute
implements ExchangeAttribute {
    public static final String REQUESTED_SESSION_ID = "%{REQUESTED_SESSION_ID}";
    public static final ServletRequestedSessionIdAttribute INSTANCE = new ServletRequestedSessionIdAttribute();

    @Override
    public String readAttribute(HttpServerExchange exchange2) {
        ServletRequest req;
        ServletRequestContext context = exchange2.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        if (context != null && (req = context.getServletRequest()) instanceof HttpServletRequest) {
            return ((HttpServletRequest)req).getRequestedSessionId();
        }
        return null;
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange2, String newValue) throws ReadOnlyAttributeException {
        throw new ReadOnlyAttributeException("Session ID", newValue);
    }

    public String toString() {
        return REQUESTED_SESSION_ID;
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Requested Session ID attribute";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.equals(ServletRequestedSessionIdAttribute.REQUESTED_SESSION_ID)) {
                return INSTANCE;
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

