/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel;

import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;

public class NoSuchPropertyException
extends CamelExchangeException {
    private final String propertyName;
    private final transient Class<?> type;

    public NoSuchPropertyException(Exchange exchange2, String propertyName) {
        this(exchange2, propertyName, null);
    }

    public NoSuchPropertyException(Exchange exchange2, String propertyName, Class<?> type) {
        super("No '" + propertyName + "' exchange property available" + (String)(type != null ? " of type: " + type.getName() : "") + NoSuchPropertyException.reason(exchange2, propertyName), exchange2);
        this.propertyName = propertyName;
        this.type = type;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Class<?> getType() {
        return this.type;
    }

    protected static String reason(Exchange exchange2, String propertyName) {
        Object value = exchange2.getProperty(propertyName);
        return NoSuchPropertyException.valueDescription(value);
    }

    static String valueDescription(Object value) {
        if (value == null) {
            return "";
        }
        return " but has type: " + value.getClass().getCanonicalName();
    }
}

