/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.security.keycloak;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.jwt.Jwt;

public class KeycloakRealmRoleConverter
implements Converter<Jwt, Collection<GrantedAuthority>> {
    public static final String REALM_ACCESS = "realm_access";
    public static final String ROLES = "roles";

    @Override
    public Collection<GrantedAuthority> convert(Jwt jwt) {
        Map realmAccess = (Map)jwt.getClaims().get(REALM_ACCESS);
        return ((List)realmAccess.get(ROLES)).stream().map(SimpleGrantedAuthority::new).collect(Collectors.toList());
    }
}

