/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.security.keycloak;

import java.util.Collections;
import java.util.Map;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.oauth2.jwt.MappedJwtClaimSetConverter;

public class KeycloakUsernameSubClaimAdapter
implements Converter<Map<String, Object>, Map<String, Object>> {
    private final MappedJwtClaimSetConverter delegate = MappedJwtClaimSetConverter.withDefaults(Collections.emptyMap());
    private final String userNameAttribute;

    public KeycloakUsernameSubClaimAdapter(String userNameAttribute) {
        this.userNameAttribute = userNameAttribute;
    }

    @Override
    public Map<String, Object> convert(Map<String, Object> claims) {
        Map<String, Object> convertedClaims = this.delegate.convert(claims);
        String username = (String)convertedClaims.get(this.userNameAttribute);
        convertedClaims.put("sub", username);
        return convertedClaims;
    }
}

