/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.undertow;

import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.component.undertow.UndertowEndpoint;
import org.apache.camel.util.CollectionHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;

public final class UndertowHelper {
    private UndertowHelper() {
    }

    public static String createURL(Exchange exchange2, UndertowEndpoint endpoint) {
        Object uri = (String)exchange2.getIn().removeHeader("CamelRestHttpUri");
        if (uri == null) {
            uri = endpoint.getHttpURI().toASCIIString();
        }
        try {
            uri = exchange2.getContext().resolvePropertyPlaceholders((String)uri);
        }
        catch (Exception e) {
            throw new RuntimeExchangeException("Cannot resolve property placeholders with uri: " + (String)uri, exchange2, e);
        }
        String path = exchange2.getIn().getHeader("CamelHttpPath", String.class);
        if (path != null) {
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (!path.isEmpty()) {
                if (!((String)uri).endsWith("/")) {
                    uri = (String)uri + "/";
                }
                uri = ((String)uri).concat(path);
            }
        }
        uri = UnsafeUriCharactersEncoder.encodeHttpURI((String)uri);
        return uri;
    }

    public static URI createURI(Exchange exchange2, String url, UndertowEndpoint endpoint) throws URISyntaxException {
        URI uri = new URI(url);
        String queryString = (String)exchange2.getIn().removeHeader("CamelRestHttpQuery");
        if (queryString == null) {
            queryString = exchange2.getIn().getHeader("CamelHttpQuery", String.class);
        }
        if (queryString == null) {
            queryString = endpoint.getHttpURI().getRawQuery();
        }
        if (queryString == null) {
            queryString = uri.getRawQuery();
        }
        if (queryString != null) {
            queryString = UnsafeUriCharactersEncoder.encodeHttpURI(queryString);
            uri = URISupport.createURIWithQuery(uri, queryString);
        }
        return uri;
    }

    public static void appendHeader(Map<String, Object> headers, String key, Object value) {
        CollectionHelper.appendEntry(headers, key, value);
    }

    public static HttpString createMethod(Exchange exchange2, UndertowEndpoint endpoint, boolean hasPayload) throws URISyntaxException {
        HttpString answer;
        String m;
        String queryString = exchange2.getIn().getHeader("CamelHttpQuery", String.class);
        String uriString = exchange2.getIn().getHeader("CamelHttpUri", String.class);
        try {
            uriString = exchange2.getContext().resolvePropertyPlaceholders(uriString);
        }
        catch (Exception e) {
            throw new RuntimeExchangeException("Cannot resolve property placeholders with uri: " + uriString, exchange2, e);
        }
        if (uriString != null) {
            URI uri = new URI(uriString);
            queryString = uri.getQuery();
        }
        if (queryString == null) {
            queryString = endpoint.getHttpURI().getRawQuery();
        }
        if ((m = exchange2.getIn().getHeader("CamelHttpMethod", String.class)) != null) {
            m = m.toUpperCase();
            answer = new HttpString(m);
        } else {
            answer = queryString != null ? Methods.GET : (hasPayload ? Methods.POST : Methods.GET);
        }
        return answer;
    }

    public static URI makeHttpURI(String httpURI) {
        return UndertowHelper.makeHttpURI(URI.create(UnsafeUriCharactersEncoder.encodeHttpURI(httpURI)));
    }

    public static URI makeHttpURI(URI httpURI) {
        if (ObjectHelper.isEmpty(httpURI.getPath())) {
            try {
                return new URI(httpURI.getScheme(), httpURI.getUserInfo(), httpURI.getHost(), httpURI.getPort(), "/", httpURI.getQuery(), httpURI.getFragment());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return httpURI;
    }
}

