/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProducer;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.EndpointAware;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Traceable;
import org.apache.camel.spi.HeadersMapFactory;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.ProducerCache;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.EventHelper;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.cache.DefaultProducerCache;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendProcessor
extends AsyncProcessorSupport
implements Traceable,
EndpointAware,
IdAware,
RouteIdAware {
    private static final Logger LOG = LoggerFactory.getLogger(SendProcessor.class);
    protected transient String traceLabelToString;
    protected final CamelContext camelContext;
    protected final ExchangePattern pattern;
    protected ProducerCache producerCache;
    protected AsyncProducer producer;
    protected HeadersMapFactory headersMapFactory;
    protected final Endpoint destination;
    protected String variableSend;
    protected String variableReceive;
    protected ExchangePattern destinationExchangePattern;
    protected String id;
    protected String routeId;
    protected boolean extendedStatistics;
    protected final AtomicLong counter = new AtomicLong();

    public SendProcessor(Endpoint destination) {
        this(destination, null);
    }

    public SendProcessor(Endpoint destination, ExchangePattern pattern) {
        ObjectHelper.notNull(destination, "destination");
        this.destination = destination;
        this.camelContext = destination.getCamelContext();
        ObjectHelper.notNull(this.camelContext, "camelContext");
        this.pattern = pattern;
        this.destinationExchangePattern = null;
        this.destinationExchangePattern = EndpointHelper.resolveExchangePatternFromUrl(destination.getEndpointUri());
    }

    public String toString() {
        return this.destination != null ? this.destination.toString() : this.id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getRouteId() {
        return this.routeId;
    }

    @Override
    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    @Override
    public String getTraceLabel() {
        if (this.traceLabelToString == null) {
            this.traceLabelToString = URISupport.sanitizeUri(this.destination.getEndpointUri());
        }
        return this.traceLabelToString;
    }

    @Override
    public Endpoint getEndpoint() {
        return this.destination;
    }

    @Override
    public boolean process(Exchange exchange2, AsyncCallback callback) {
        if (!this.isStarted()) {
            exchange2.setException(new IllegalStateException("SendProcessor has not been started: " + this));
            callback.done(true);
            return true;
        }
        ExchangePattern existingPattern = exchange2.getPattern();
        Object body2 = null;
        Map<String, Object> headers = null;
        if (this.variableSend != null || this.variableReceive != null) {
            try {
                body2 = exchange2.getMessage().getBody();
                headers = this.headersMapFactory.newMap(exchange2.getMessage().getHeaders());
            }
            catch (Exception throwable) {
                exchange2.setException(throwable);
                callback.done(true);
                return true;
            }
        }
        Object originalBody = body2;
        Map<String, Object> originalHeaders = headers;
        if (this.extendedStatistics) {
            this.counter.incrementAndGet();
        }
        if (this.producer != null) {
            boolean newCallback;
            Exchange target = exchange2;
            if (this.destinationExchangePattern != null || this.pattern != null) {
                target.setPattern(this.destinationExchangePattern != null ? this.destinationExchangePattern : this.pattern);
            }
            exchange2.setProperty(ExchangePropertyKey.TO_ENDPOINT, (Object)this.destination.getEndpointUri());
            boolean sending = this.camelContext.getCamelContextExtension().isEventNotificationApplicable() && EventHelper.notifyExchangeSending(exchange2.getContext(), target, this.destination);
            StopWatch watch = sending ? new StopWatch() : null;
            AsyncCallback ac = callback;
            boolean bl = newCallback = watch != null || existingPattern != target.getPattern() || this.variableReceive != null;
            if (newCallback) {
                ac = doneSync -> {
                    try {
                        if (ExchangeHelper.shouldSetVariableResult(target, this.variableReceive)) {
                            ExchangeHelper.setVariableFromMessageBodyAndHeaders(target, this.variableReceive, target.getMessage());
                            target.getMessage().setBody(originalBody);
                            target.getMessage().setHeaders(originalHeaders);
                        }
                        target.setPattern(existingPattern);
                        if (watch != null) {
                            long timeTaken = watch.taken();
                            EventHelper.notifyExchangeSent(target.getContext(), target, this.destination, timeTaken);
                        }
                    }
                    finally {
                        callback.done(doneSync);
                    }
                };
            }
            try {
                if (this.variableSend != null) {
                    Object value = ExchangeHelper.getVariable(exchange2, this.variableSend);
                    exchange2.getMessage().setBody(value);
                }
                LOG.debug(">>>> {} {}", (Object)this.destination, (Object)exchange2);
                boolean sync = this.producer.process(exchange2, ac);
                if (!sync) {
                    EventHelper.notifyExchangeAsyncProcessingStartedEvent(this.camelContext, exchange2);
                }
                return sync;
            }
            catch (Exception throwable) {
                exchange2.setException(throwable);
                callback.done(true);
                return true;
            }
        }
        if (this.destinationExchangePattern != null || this.pattern != null) {
            exchange2.setPattern(this.destinationExchangePattern != null ? this.destinationExchangePattern : this.pattern);
        }
        exchange2.setProperty(ExchangePropertyKey.TO_ENDPOINT, (Object)this.destination.getEndpointUri());
        if (this.variableSend != null) {
            Object value = ExchangeHelper.getVariable(exchange2, this.variableSend);
            exchange2.getMessage().setBody(value);
        }
        LOG.debug(">>>> {} {}", (Object)this.destination, (Object)exchange2);
        return this.producerCache.doInAsyncProducer(this.destination, exchange2, callback, (producer, ex, cb) -> producer.process(ex, doneSync -> {
            exchange2.setPattern(existingPattern);
            if (ExchangeHelper.shouldSetVariableResult(exchange2, this.variableReceive)) {
                ExchangeHelper.setVariableFromMessageBodyAndHeaders(exchange2, this.variableReceive, exchange2.getMessage());
                exchange2.getMessage().setBody(originalBody);
                exchange2.getMessage().setHeaders(originalHeaders);
            }
            cb.done(doneSync);
        }));
    }

    public String getVariableSend() {
        return this.variableSend;
    }

    public void setVariableSend(String variableSend) {
        this.variableSend = variableSend;
    }

    public String getVariableReceive() {
        return this.variableReceive;
    }

    public void setVariableReceive(String variableReceive) {
        this.variableReceive = variableReceive;
    }

    public Endpoint getDestination() {
        return this.destination;
    }

    public ExchangePattern getPattern() {
        return this.pattern;
    }

    public long getCounter() {
        return this.counter.get();
    }

    public void reset() {
        this.counter.set(0L);
    }

    @Override
    protected void doInit() throws Exception {
        this.extendedStatistics = this.camelContext.getManagementStrategy() != null && this.camelContext.getManagementStrategy().getManagementAgent() != null ? this.camelContext.getManagementStrategy().getManagementAgent().getStatisticsLevel().isExtended() : false;
        if (!this.destination.isSingletonProducer() && this.producerCache == null) {
            this.producerCache = new DefaultProducerCache(this, this.camelContext, 0);
        }
        this.headersMapFactory = this.camelContext.getCamelContextExtension().getHeadersMapFactory();
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startService(this.destination);
        if (this.destination.isSingletonProducer()) {
            this.producer = this.destination.createAsyncProducer();
            AsyncProducer asyncProducer = this.producer;
            if (asyncProducer instanceof RouteIdAware) {
                RouteIdAware ria = (RouteIdAware)((Object)asyncProducer);
                ria.setRouteId(this.getRouteId());
            }
            this.camelContext.addService(this.producer, true, true);
        } else {
            ServiceHelper.startService(this.producerCache);
        }
    }

    @Override
    protected void doStop() throws Exception {
        if (this.producer != null) {
            this.camelContext.removeService(this.producer);
        }
        ServiceHelper.stopService(this.producerCache, this.producer);
    }

    @Override
    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices(this.producerCache, this.producer);
    }
}

