/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization.method;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.core.MethodClassKey;
import org.springframework.lang.NonNull;
import org.springframework.security.access.expression.method.DefaultMethodSecurityExpressionHandler;
import org.springframework.security.access.expression.method.MethodSecurityExpressionHandler;
import org.springframework.security.authorization.method.AuthorizationAnnotationUtils;
import org.springframework.security.authorization.method.ExpressionAttribute;
import org.springframework.security.authorization.method.PrePostTemplateDefaults;
import org.springframework.util.Assert;

abstract class AbstractExpressionAttributeRegistry<T extends ExpressionAttribute> {
    private final Map<MethodClassKey, T> cachedAttributes = new ConcurrentHashMap<MethodClassKey, T>();
    private MethodSecurityExpressionHandler expressionHandler = new DefaultMethodSecurityExpressionHandler();
    private PrePostTemplateDefaults defaults;

    AbstractExpressionAttributeRegistry() {
    }

    final T getAttribute(MethodInvocation mi) {
        Method method = mi.getMethod();
        Object target = mi.getThis();
        Class<?> targetClass = target != null ? target.getClass() : null;
        return this.getAttribute(method, targetClass);
    }

    final T getAttribute(Method method, Class<?> targetClass) {
        MethodClassKey cacheKey = new MethodClassKey(method, targetClass);
        return (T)this.cachedAttributes.computeIfAbsent(cacheKey, k -> this.resolveAttribute(method, targetClass));
    }

    final <A extends Annotation> Function<AnnotatedElement, A> findUniqueAnnotation(Class<A> type) {
        return this.defaults != null ? AuthorizationAnnotationUtils.withDefaults(type, this.defaults) : AuthorizationAnnotationUtils.withDefaults(type);
    }

    MethodSecurityExpressionHandler getExpressionHandler() {
        return this.expressionHandler;
    }

    void setExpressionHandler(MethodSecurityExpressionHandler expressionHandler) {
        Assert.notNull((Object)expressionHandler, "expressionHandler cannot be null");
        this.expressionHandler = expressionHandler;
    }

    void setTemplateDefaults(PrePostTemplateDefaults defaults) {
        this.defaults = defaults;
    }

    @NonNull
    abstract T resolveAttribute(Method var1, Class<?> var2);
}

