/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.core.session;

import java.io.Serializable;
import java.time.Instant;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class ReactiveSessionInformation
implements Serializable {
    private static final long serialVersionUID = 620L;
    private Instant lastAccessTime;
    private final Object principal;
    private final String sessionId;
    private boolean expired = false;

    public ReactiveSessionInformation(Object principal2, String sessionId, Instant lastAccessTime) {
        Assert.notNull(principal2, "principal cannot be null");
        Assert.hasText(sessionId, "sessionId cannot be null");
        Assert.notNull((Object)lastAccessTime, "lastAccessTime cannot be null");
        this.principal = principal2;
        this.sessionId = sessionId;
        this.lastAccessTime = lastAccessTime;
    }

    public ReactiveSessionInformation withSessionId(String sessionId) {
        return new ReactiveSessionInformation(this.principal, sessionId, this.lastAccessTime);
    }

    public Mono<Void> invalidate() {
        return Mono.fromRunnable(() -> {
            this.expired = true;
        });
    }

    public Mono<Void> refreshLastRequest() {
        this.lastAccessTime = Instant.now();
        return Mono.empty();
    }

    public Instant getLastAccessTime() {
        return this.lastAccessTime;
    }

    public Object getPrincipal() {
        return this.principal;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public void setLastAccessTime(Instant lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }
}

