/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client;

import org.springframework.security.oauth2.core.OAuth2AuthorizationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.util.Assert;

public class ClientAuthorizationException
extends OAuth2AuthorizationException {
    private final String clientRegistrationId;

    public ClientAuthorizationException(OAuth2Error error, String clientRegistrationId) {
        this(error, clientRegistrationId, error.toString());
    }

    public ClientAuthorizationException(OAuth2Error error, String clientRegistrationId, String message) {
        super(error, message);
        Assert.hasText(clientRegistrationId, "clientRegistrationId cannot be empty");
        this.clientRegistrationId = clientRegistrationId;
    }

    public ClientAuthorizationException(OAuth2Error error, String clientRegistrationId, Throwable cause) {
        this(error, clientRegistrationId, error.toString(), cause);
    }

    public ClientAuthorizationException(OAuth2Error error, String clientRegistrationId, String message, Throwable cause) {
        super(error, message, cause);
        Assert.hasText(clientRegistrationId, "clientRegistrationId cannot be empty");
        this.clientRegistrationId = clientRegistrationId;
    }

    public String getClientRegistrationId() {
        return this.clientRegistrationId;
    }
}

