/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.endpoint;

import java.util.Set;
import org.springframework.security.oauth2.client.endpoint.AbstractWebClientReactiveOAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2RefreshTokenGrantRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.endpoint.OAuth2AccessTokenResponse;
import org.springframework.util.CollectionUtils;
import org.springframework.web.reactive.function.BodyInserters;

public final class WebClientReactiveRefreshTokenTokenResponseClient
extends AbstractWebClientReactiveOAuth2AccessTokenResponseClient<OAuth2RefreshTokenGrantRequest> {
    @Override
    ClientRegistration clientRegistration(OAuth2RefreshTokenGrantRequest grantRequest) {
        return grantRequest.getClientRegistration();
    }

    @Override
    Set<String> scopes(OAuth2RefreshTokenGrantRequest grantRequest) {
        return grantRequest.getScopes();
    }

    @Override
    Set<String> defaultScopes(OAuth2RefreshTokenGrantRequest grantRequest) {
        return grantRequest.getAccessToken().getScopes();
    }

    @Override
    BodyInserters.FormInserter<String> populateTokenRequestBody(OAuth2RefreshTokenGrantRequest grantRequest, BodyInserters.FormInserter<String> body2) {
        return super.populateTokenRequestBody(grantRequest, body2).with("refresh_token", (Object)grantRequest.getRefreshToken().getTokenValue());
    }

    @Override
    OAuth2AccessTokenResponse populateTokenResponse(OAuth2RefreshTokenGrantRequest grantRequest, OAuth2AccessTokenResponse accessTokenResponse) {
        if (!CollectionUtils.isEmpty(accessTokenResponse.getAccessToken().getScopes()) && accessTokenResponse.getRefreshToken() != null) {
            return accessTokenResponse;
        }
        OAuth2AccessTokenResponse.Builder tokenResponseBuilder = OAuth2AccessTokenResponse.withResponse(accessTokenResponse);
        if (CollectionUtils.isEmpty(accessTokenResponse.getAccessToken().getScopes())) {
            tokenResponseBuilder.scopes(this.defaultScopes(grantRequest));
        }
        if (accessTokenResponse.getRefreshToken() == null) {
            tokenResponseBuilder.refreshToken(grantRequest.getRefreshToken().getTokenValue());
        }
        return tokenResponseBuilder.build();
    }
}

