/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.jackson2;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.util.StdConverter;
import java.io.IOException;
import org.springframework.security.oauth2.client.jackson2.JsonNodeUtils;
import org.springframework.security.oauth2.client.jackson2.StdConverters;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;

final class OAuth2AuthorizationRequestDeserializer
extends JsonDeserializer<OAuth2AuthorizationRequest> {
    private static final StdConverter<JsonNode, AuthorizationGrantType> AUTHORIZATION_GRANT_TYPE_CONVERTER = new StdConverters.AuthorizationGrantTypeConverter();

    OAuth2AuthorizationRequestDeserializer() {
    }

    public OAuth2AuthorizationRequest deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        ObjectMapper mapper = (ObjectMapper)parser.getCodec();
        JsonNode root = (JsonNode)mapper.readTree(parser);
        return this.deserialize(parser, mapper, root);
    }

    private OAuth2AuthorizationRequest deserialize(JsonParser parser, ObjectMapper mapper, JsonNode root) throws JsonParseException {
        AuthorizationGrantType authorizationGrantType = (AuthorizationGrantType)AUTHORIZATION_GRANT_TYPE_CONVERTER.convert((Object)JsonNodeUtils.findObjectNode(root, "authorizationGrantType"));
        OAuth2AuthorizationRequest.Builder builder = this.getBuilder(parser, authorizationGrantType);
        builder.authorizationUri(JsonNodeUtils.findStringValue(root, "authorizationUri"));
        builder.clientId(JsonNodeUtils.findStringValue(root, "clientId"));
        builder.redirectUri(JsonNodeUtils.findStringValue(root, "redirectUri"));
        builder.scopes(JsonNodeUtils.findValue(root, "scopes", JsonNodeUtils.STRING_SET, mapper));
        builder.state(JsonNodeUtils.findStringValue(root, "state"));
        builder.additionalParameters(JsonNodeUtils.findValue(root, "additionalParameters", JsonNodeUtils.STRING_OBJECT_MAP, mapper));
        builder.authorizationRequestUri(JsonNodeUtils.findStringValue(root, "authorizationRequestUri"));
        builder.attributes(JsonNodeUtils.findValue(root, "attributes", JsonNodeUtils.STRING_OBJECT_MAP, mapper));
        return builder.build();
    }

    private OAuth2AuthorizationRequest.Builder getBuilder(JsonParser parser, AuthorizationGrantType authorizationGrantType) throws JsonParseException {
        if (AuthorizationGrantType.AUTHORIZATION_CODE.equals(authorizationGrantType)) {
            return OAuth2AuthorizationRequest.authorizationCode();
        }
        throw new JsonParseException(parser, "Invalid authorizationGrantType");
    }
}

