/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.oidc.session;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.oauth2.client.oidc.authentication.logout.OidcLogoutToken;
import org.springframework.security.oauth2.client.oidc.session.OidcSessionInformation;
import org.springframework.security.oauth2.client.oidc.session.OidcSessionRegistry;

public final class InMemoryOidcSessionRegistry
implements OidcSessionRegistry {
    private final Log logger = LogFactory.getLog(InMemoryOidcSessionRegistry.class);
    private final Map<String, OidcSessionInformation> sessions = new ConcurrentHashMap<String, OidcSessionInformation>();

    @Override
    public void saveSessionInformation(OidcSessionInformation info) {
        this.sessions.put(info.getSessionId(), info);
    }

    @Override
    public OidcSessionInformation removeSessionInformation(String clientSessionId) {
        OidcSessionInformation information = this.sessions.remove(clientSessionId);
        if (information != null) {
            this.logger.trace("Removed client session");
        }
        return information;
    }

    @Override
    public Iterable<OidcSessionInformation> removeSessionInformation(OidcLogoutToken token) {
        Predicate<OidcSessionInformation> matcher;
        List<String> audience = token.getAudience();
        String issuer = token.getIssuer().toString();
        String subject = token.getSubject();
        String providerSessionId = token.getSessionId();
        Predicate<OidcSessionInformation> predicate = matcher = providerSessionId != null ? InMemoryOidcSessionRegistry.sessionIdMatcher(audience, issuer, providerSessionId) : InMemoryOidcSessionRegistry.subjectMatcher(audience, issuer, subject);
        if (this.logger.isTraceEnabled()) {
            String message = "Looking up sessions by issuer [%s] and %s [%s]";
            if (providerSessionId != null) {
                this.logger.trace(String.format(message, issuer, "sid", providerSessionId));
            } else {
                this.logger.trace(String.format(message, issuer, "sub", subject));
            }
        }
        int size = this.sessions.size();
        HashSet<OidcSessionInformation> infos = new HashSet<OidcSessionInformation>();
        this.sessions.values().removeIf(info -> {
            boolean result = matcher.test((OidcSessionInformation)info);
            if (result) {
                infos.add((OidcSessionInformation)info);
            }
            return result;
        });
        if (infos.isEmpty()) {
            this.logger.debug("Failed to remove any sessions since none matched");
        } else if (this.logger.isTraceEnabled()) {
            String message = "Found and removed %d session(s) from mapping of %d session(s)";
            this.logger.trace(String.format(message, infos.size(), size));
        }
        return infos;
    }

    private static Predicate<OidcSessionInformation> sessionIdMatcher(List<String> audience, String issuer, String sessionId) {
        return session -> {
            List<String> thatAudience = session.getPrincipal().getAudience();
            String thatIssuer = session.getPrincipal().getIssuer().toString();
            String thatSessionId = session.getPrincipal().getClaimAsString("sid");
            if (thatAudience == null) {
                return false;
            }
            return !Collections.disjoint(audience, thatAudience) && issuer.equals(thatIssuer) && sessionId.equals(thatSessionId);
        };
    }

    private static Predicate<OidcSessionInformation> subjectMatcher(List<String> audience, String issuer, String subject) {
        return session -> {
            List<String> thatAudience = session.getPrincipal().getAudience();
            String thatIssuer = session.getPrincipal().getIssuer().toString();
            String thatSubject = session.getPrincipal().getSubject();
            if (thatAudience == null) {
                return false;
            }
            return !Collections.disjoint(audience, thatAudience) && issuer.equals(thatIssuer) && subject.equals(thatSubject);
        };
    }
}

