/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.registration;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public final class InMemoryReactiveClientRegistrationRepository
implements ReactiveClientRegistrationRepository,
Iterable<ClientRegistration> {
    private final Map<String, ClientRegistration> clientIdToClientRegistration;

    public InMemoryReactiveClientRegistrationRepository(ClientRegistration ... registrations) {
        this(InMemoryReactiveClientRegistrationRepository.toList(registrations));
    }

    private static List<ClientRegistration> toList(ClientRegistration ... registrations) {
        Assert.notEmpty((Object[])registrations, "registrations cannot be null or empty");
        return Arrays.asList(registrations);
    }

    public InMemoryReactiveClientRegistrationRepository(List<ClientRegistration> registrations) {
        this.clientIdToClientRegistration = InMemoryReactiveClientRegistrationRepository.toUnmodifiableConcurrentMap(registrations);
    }

    @Override
    public Mono<ClientRegistration> findByRegistrationId(String registrationId) {
        return Mono.justOrEmpty((Object)this.clientIdToClientRegistration.get(registrationId));
    }

    @Override
    public Iterator<ClientRegistration> iterator() {
        return this.clientIdToClientRegistration.values().iterator();
    }

    private static Map<String, ClientRegistration> toUnmodifiableConcurrentMap(List<ClientRegistration> registrations) {
        Assert.notEmpty(registrations, "registrations cannot be null or empty");
        ConcurrentHashMap<String, ClientRegistration> result = new ConcurrentHashMap<String, ClientRegistration>();
        for (ClientRegistration registration : registrations) {
            Assert.notNull((Object)registration, "no registration can be null");
            if (result.containsKey(registration.getRegistrationId())) {
                throw new IllegalStateException(String.format("Duplicate key %s", registration.getRegistrationId()));
            }
            result.put(registration.getRegistrationId(), registration);
        }
        return Collections.unmodifiableMap(result);
    }
}

