/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.web;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.HashMap;
import java.util.Map;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;
import org.springframework.util.Assert;

public final class HttpSessionOAuth2AuthorizedClientRepository
implements OAuth2AuthorizedClientRepository {
    private static final String DEFAULT_AUTHORIZED_CLIENTS_ATTR_NAME = HttpSessionOAuth2AuthorizedClientRepository.class.getName() + ".AUTHORIZED_CLIENTS";
    private final String sessionAttributeName = DEFAULT_AUTHORIZED_CLIENTS_ATTR_NAME;

    @Override
    public <T extends OAuth2AuthorizedClient> T loadAuthorizedClient(String clientRegistrationId, Authentication principal2, HttpServletRequest request) {
        Assert.hasText(clientRegistrationId, "clientRegistrationId cannot be empty");
        Assert.notNull((Object)request, "request cannot be null");
        return (T)this.getAuthorizedClients(request).get(clientRegistrationId);
    }

    @Override
    public void saveAuthorizedClient(OAuth2AuthorizedClient authorizedClient, Authentication principal2, HttpServletRequest request, HttpServletResponse response) {
        Assert.notNull((Object)authorizedClient, "authorizedClient cannot be null");
        Assert.notNull((Object)request, "request cannot be null");
        Assert.notNull((Object)response, "response cannot be null");
        Map<String, OAuth2AuthorizedClient> authorizedClients = this.getAuthorizedClients(request);
        authorizedClients.put(authorizedClient.getClientRegistration().getRegistrationId(), authorizedClient);
        request.getSession().setAttribute(this.sessionAttributeName, authorizedClients);
    }

    @Override
    public void removeAuthorizedClient(String clientRegistrationId, Authentication principal2, HttpServletRequest request, HttpServletResponse response) {
        Assert.hasText(clientRegistrationId, "clientRegistrationId cannot be empty");
        Assert.notNull((Object)request, "request cannot be null");
        Map<String, OAuth2AuthorizedClient> authorizedClients = this.getAuthorizedClients(request);
        if (!authorizedClients.isEmpty() && authorizedClients.remove(clientRegistrationId) != null) {
            if (!authorizedClients.isEmpty()) {
                request.getSession().setAttribute(this.sessionAttributeName, authorizedClients);
            } else {
                request.getSession().removeAttribute(this.sessionAttributeName);
            }
        }
    }

    private Map<String, OAuth2AuthorizedClient> getAuthorizedClients(HttpServletRequest request) {
        HashMap authorizedClients;
        HttpSession session = request.getSession(false);
        HashMap hashMap = authorizedClients = session != null ? (HashMap)session.getAttribute(this.sessionAttributeName) : null;
        if (authorizedClients == null) {
            authorizedClients = new HashMap();
        }
        return authorizedClients;
    }
}

