/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.web.reactive.result.method.annotation;

import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.oauth2.client.OAuth2AuthorizeRequest;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.annotation.RegisteredOAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.DefaultReactiveOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.web.server.ServerOAuth2AuthorizedClientRepository;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolver;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public final class OAuth2AuthorizedClientArgumentResolver
implements HandlerMethodArgumentResolver {
    private static final AnonymousAuthenticationToken ANONYMOUS_USER_TOKEN = new AnonymousAuthenticationToken("anonymous", (Object)"anonymousUser", AuthorityUtils.createAuthorityList("ROLE_USER"));
    private ReactiveOAuth2AuthorizedClientManager authorizedClientManager;

    public OAuth2AuthorizedClientArgumentResolver(ReactiveOAuth2AuthorizedClientManager authorizedClientManager) {
        Assert.notNull((Object)authorizedClientManager, "authorizedClientManager cannot be null");
        this.authorizedClientManager = authorizedClientManager;
    }

    public OAuth2AuthorizedClientArgumentResolver(ReactiveClientRegistrationRepository clientRegistrationRepository, ServerOAuth2AuthorizedClientRepository authorizedClientRepository) {
        Assert.notNull((Object)clientRegistrationRepository, "clientRegistrationRepository cannot be null");
        Assert.notNull((Object)authorizedClientRepository, "authorizedClientRepository cannot be null");
        this.authorizedClientManager = new DefaultReactiveOAuth2AuthorizedClientManager(clientRegistrationRepository, authorizedClientRepository);
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return AnnotatedElementUtils.findMergedAnnotation(parameter.getParameter(), RegisteredOAuth2AuthorizedClient.class) != null;
    }

    public Mono<Object> resolveArgument(MethodParameter parameter, BindingContext bindingContext, ServerWebExchange exchange2) {
        return Mono.defer(() -> {
            RegisteredOAuth2AuthorizedClient authorizedClientAnnotation = AnnotatedElementUtils.findMergedAnnotation(parameter.getParameter(), RegisteredOAuth2AuthorizedClient.class);
            String clientRegistrationId = StringUtils.hasLength(authorizedClientAnnotation.registrationId()) ? authorizedClientAnnotation.registrationId() : null;
            return this.authorizeRequest(clientRegistrationId, exchange2).flatMap(this.authorizedClientManager::authorize);
        });
    }

    private Mono<OAuth2AuthorizeRequest> authorizeRequest(String registrationId, ServerWebExchange exchange2) {
        Mono<Authentication> defaultedAuthentication = this.currentAuthentication();
        Mono defaultedRegistrationId = Mono.justOrEmpty((Object)registrationId).switchIfEmpty(this.clientRegistrationId(defaultedAuthentication)).switchIfEmpty(Mono.error(() -> new IllegalArgumentException("The clientRegistrationId could not be resolved. Please provide one")));
        Mono defaultedExchange = Mono.justOrEmpty((Object)exchange2).switchIfEmpty(this.currentServerWebExchange());
        return Mono.zip((Mono)defaultedRegistrationId, defaultedAuthentication, (Mono)defaultedExchange).map(zipped -> OAuth2AuthorizeRequest.withClientRegistrationId((String)zipped.getT1()).principal((Authentication)zipped.getT2()).attribute(ServerWebExchange.class.getName(), zipped.getT3()).build());
    }

    private Mono<Authentication> currentAuthentication() {
        return ReactiveSecurityContextHolder.getContext().map(SecurityContext::getAuthentication).defaultIfEmpty((Object)ANONYMOUS_USER_TOKEN);
    }

    private Mono<String> clientRegistrationId(Mono<Authentication> authentication) {
        return authentication.filter(t -> t instanceof OAuth2AuthenticationToken).cast(OAuth2AuthenticationToken.class).map(OAuth2AuthenticationToken::getAuthorizedClientRegistrationId);
    }

    private Mono<ServerWebExchange> currentServerWebExchange() {
        return Mono.deferContextual(Mono::just).filter(c -> c.hasKey(ServerWebExchange.class)).map(c -> (ServerWebExchange)c.get(ServerWebExchange.class));
    }
}

