/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidatorResult;
import org.springframework.util.Assert;

public final class DelegatingOAuth2TokenValidator<T extends OAuth2Token>
implements OAuth2TokenValidator<T> {
    private final Collection<OAuth2TokenValidator<T>> tokenValidators;

    public DelegatingOAuth2TokenValidator(Collection<OAuth2TokenValidator<T>> tokenValidators) {
        Assert.notNull(tokenValidators, "tokenValidators cannot be null");
        this.tokenValidators = new ArrayList<OAuth2TokenValidator<T>>(tokenValidators);
    }

    @SafeVarargs
    public DelegatingOAuth2TokenValidator(OAuth2TokenValidator<T> ... tokenValidators) {
        this(Arrays.asList(tokenValidators));
    }

    @Override
    public OAuth2TokenValidatorResult validate(T token) {
        ArrayList<OAuth2Error> errors = new ArrayList<OAuth2Error>();
        for (OAuth2TokenValidator<T> validator : this.tokenValidators) {
            errors.addAll(validator.validate(token).getErrors());
        }
        return OAuth2TokenValidatorResult.failure(errors);
    }
}

