/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.core.authorization;

import org.springframework.security.authorization.AuthorityAuthorizationManager;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.util.Assert;

public final class OAuth2AuthorizationManagers {
    private OAuth2AuthorizationManagers() {
    }

    public static <T> AuthorizationManager<T> hasScope(String scope) {
        OAuth2AuthorizationManagers.assertScope(scope);
        return AuthorityAuthorizationManager.hasAuthority("SCOPE_" + scope);
    }

    public static <T> AuthorizationManager<T> hasAnyScope(String ... scopes) {
        String[] mappedScopes = new String[scopes.length];
        for (int i = 0; i < scopes.length; ++i) {
            OAuth2AuthorizationManagers.assertScope(scopes[i]);
            mappedScopes[i] = "SCOPE_" + scopes[i];
        }
        return AuthorityAuthorizationManager.hasAnyAuthority(mappedScopes);
    }

    private static void assertScope(String scope) {
        Assert.isTrue(!scope.startsWith("SCOPE_"), () -> scope + " should not start with SCOPE_ since SCOPE_ is automatically prepended when using hasScope and hasAnyScope. Consider using  AuthorityAuthorizationManager#hasAuthority or #hasAnyAuthority instead.");
    }
}

