/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.core.converter;

import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;

final class ObjectToInstantConverter
implements GenericConverter {
    ObjectToInstantConverter() {
    }

    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Object.class, Instant.class));
    }

    @Override
    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        if (source instanceof Instant) {
            return source;
        }
        if (source instanceof Date) {
            return ((Date)source).toInstant();
        }
        if (source instanceof Number) {
            return Instant.ofEpochSecond(((Number)source).longValue());
        }
        try {
            return Instant.ofEpochSecond(Long.parseLong(source.toString()));
        }
        catch (Exception exception) {
            try {
                return Instant.parse(source.toString());
            }
            catch (Exception exception2) {
                return null;
            }
        }
    }
}

