/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.core.converter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.util.ClassUtils;

final class ObjectToListStringConverter
implements ConditionalGenericConverter {
    ObjectToListStringConverter() {
    }

    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        LinkedHashSet<GenericConverter.ConvertiblePair> convertibleTypes = new LinkedHashSet<GenericConverter.ConvertiblePair>();
        convertibleTypes.add(new GenericConverter.ConvertiblePair(Object.class, List.class));
        convertibleTypes.add(new GenericConverter.ConvertiblePair(Object.class, Collection.class));
        return convertibleTypes;
    }

    @Override
    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return targetType.getElementTypeDescriptor() == null || targetType.getElementTypeDescriptor().getType().equals(String.class) || sourceType == null || ClassUtils.isAssignable(sourceType.getType(), targetType.getElementTypeDescriptor().getType());
    }

    @Override
    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        if (source instanceof Collection) {
            ArrayList<String> results = new ArrayList<String>();
            for (Object object : (Collection)source) {
                if (object == null) continue;
                results.add(object.toString());
            }
            return results;
        }
        return Collections.singletonList(source.toString());
    }
}

