/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.core.endpoint;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.oauth2.core.endpoint.OAuth2AccessTokenResponse;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public final class DefaultOAuth2AccessTokenResponseMapConverter
implements Converter<OAuth2AccessTokenResponse, Map<String, Object>> {
    @Override
    public Map<String, Object> convert(OAuth2AccessTokenResponse tokenResponse) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("access_token", tokenResponse.getAccessToken().getTokenValue());
        parameters.put("token_type", tokenResponse.getAccessToken().getTokenType().getValue());
        parameters.put("expires_in", DefaultOAuth2AccessTokenResponseMapConverter.getExpiresIn(tokenResponse));
        if (!CollectionUtils.isEmpty(tokenResponse.getAccessToken().getScopes())) {
            parameters.put("scope", StringUtils.collectionToDelimitedString(tokenResponse.getAccessToken().getScopes(), " "));
        }
        if (tokenResponse.getRefreshToken() != null) {
            parameters.put("refresh_token", tokenResponse.getRefreshToken().getTokenValue());
        }
        if (!CollectionUtils.isEmpty(tokenResponse.getAdditionalParameters())) {
            for (Map.Entry<String, Object> entry : tokenResponse.getAdditionalParameters().entrySet()) {
                parameters.put(entry.getKey(), entry.getValue());
            }
        }
        return parameters;
    }

    private static long getExpiresIn(OAuth2AccessTokenResponse tokenResponse) {
        if (tokenResponse.getAccessToken().getExpiresAt() != null) {
            return ChronoUnit.SECONDS.between(Instant.now(), tokenResponse.getAccessToken().getExpiresAt());
        }
        return -1L;
    }
}

