/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.core.endpoint;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Map;
import org.springframework.security.oauth2.core.OAuth2DeviceCode;
import org.springframework.security.oauth2.core.OAuth2UserCode;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public final class OAuth2DeviceAuthorizationResponse {
    private OAuth2DeviceCode deviceCode;
    private OAuth2UserCode userCode;
    private String verificationUri;
    private String verificationUriComplete;
    private long interval;
    private Map<String, Object> additionalParameters;

    private OAuth2DeviceAuthorizationResponse() {
    }

    public OAuth2DeviceCode getDeviceCode() {
        return this.deviceCode;
    }

    public OAuth2UserCode getUserCode() {
        return this.userCode;
    }

    public String getVerificationUri() {
        return this.verificationUri;
    }

    public String getVerificationUriComplete() {
        return this.verificationUriComplete;
    }

    public long getInterval() {
        return this.interval;
    }

    public Map<String, Object> getAdditionalParameters() {
        return this.additionalParameters;
    }

    public static Builder with(String deviceCode, String userCode) {
        Assert.hasText(deviceCode, "deviceCode cannot be empty");
        Assert.hasText(userCode, "userCode cannot be empty");
        return new Builder(deviceCode, userCode);
    }

    public static Builder with(OAuth2DeviceCode deviceCode, OAuth2UserCode userCode) {
        Assert.notNull((Object)deviceCode, "deviceCode cannot be null");
        Assert.notNull((Object)userCode, "userCode cannot be null");
        return new Builder(deviceCode, userCode);
    }

    public static final class Builder {
        private final String deviceCode;
        private final String userCode;
        private String verificationUri;
        private String verificationUriComplete;
        private long expiresIn;
        private long interval;
        private Map<String, Object> additionalParameters;

        private Builder(OAuth2DeviceCode deviceCode, OAuth2UserCode userCode) {
            this.deviceCode = deviceCode.getTokenValue();
            this.userCode = userCode.getTokenValue();
            this.expiresIn = ChronoUnit.SECONDS.between(deviceCode.getIssuedAt(), deviceCode.getExpiresAt());
        }

        private Builder(String deviceCode, String userCode) {
            this.deviceCode = deviceCode;
            this.userCode = userCode;
        }

        public Builder verificationUri(String verificationUri) {
            this.verificationUri = verificationUri;
            return this;
        }

        public Builder verificationUriComplete(String verificationUriComplete) {
            this.verificationUriComplete = verificationUriComplete;
            return this;
        }

        public Builder expiresIn(long expiresIn) {
            this.expiresIn = expiresIn;
            return this;
        }

        public Builder interval(long interval) {
            this.interval = interval;
            return this;
        }

        public Builder additionalParameters(Map<String, Object> additionalParameters) {
            this.additionalParameters = additionalParameters;
            return this;
        }

        public OAuth2DeviceAuthorizationResponse build() {
            Assert.hasText(this.verificationUri, "verificationUri cannot be empty");
            Assert.isTrue(this.expiresIn > 0L, "expiresIn must be greater than zero");
            Instant issuedAt = Instant.now();
            Instant expiresAt = issuedAt.plusSeconds(this.expiresIn);
            OAuth2DeviceCode deviceCode = new OAuth2DeviceCode(this.deviceCode, issuedAt, expiresAt);
            OAuth2UserCode userCode = new OAuth2UserCode(this.userCode, issuedAt, expiresAt);
            OAuth2DeviceAuthorizationResponse deviceAuthorizationResponse = new OAuth2DeviceAuthorizationResponse();
            deviceAuthorizationResponse.deviceCode = deviceCode;
            deviceAuthorizationResponse.userCode = userCode;
            deviceAuthorizationResponse.verificationUri = this.verificationUri;
            deviceAuthorizationResponse.verificationUriComplete = this.verificationUriComplete;
            deviceAuthorizationResponse.interval = this.interval;
            deviceAuthorizationResponse.additionalParameters = Collections.unmodifiableMap(CollectionUtils.isEmpty(this.additionalParameters) ? Collections.emptyMap() : this.additionalParameters);
            return deviceAuthorizationResponse;
        }
    }
}

