/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.jwt;

import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.security.oauth2.core.AbstractOAuth2Token;
import org.springframework.security.oauth2.jwt.JwtClaimAccessor;
import org.springframework.util.Assert;

public class Jwt
extends AbstractOAuth2Token
implements JwtClaimAccessor {
    private final Map<String, Object> headers;
    private final Map<String, Object> claims;

    public Jwt(String tokenValue, Instant issuedAt, Instant expiresAt, Map<String, Object> headers, Map<String, Object> claims) {
        super(tokenValue, issuedAt, expiresAt);
        Assert.notEmpty(headers, "headers cannot be empty");
        Assert.notEmpty(claims, "claims cannot be empty");
        this.headers = Collections.unmodifiableMap(new LinkedHashMap<String, Object>(headers));
        this.claims = Collections.unmodifiableMap(new LinkedHashMap<String, Object>(claims));
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    @Override
    public Map<String, Object> getClaims() {
        return this.claims;
    }

    public static Builder withTokenValue(String tokenValue) {
        return new Builder(tokenValue);
    }

    public static final class Builder {
        private String tokenValue;
        private final Map<String, Object> claims = new LinkedHashMap<String, Object>();
        private final Map<String, Object> headers = new LinkedHashMap<String, Object>();

        private Builder(String tokenValue) {
            this.tokenValue = tokenValue;
        }

        public Builder tokenValue(String tokenValue) {
            this.tokenValue = tokenValue;
            return this;
        }

        public Builder claim(String name, Object value) {
            this.claims.put(name, value);
            return this;
        }

        public Builder claims(Consumer<Map<String, Object>> claimsConsumer) {
            claimsConsumer.accept(this.claims);
            return this;
        }

        public Builder header(String name, Object value) {
            this.headers.put(name, value);
            return this;
        }

        public Builder headers(Consumer<Map<String, Object>> headersConsumer) {
            headersConsumer.accept(this.headers);
            return this;
        }

        public Builder audience(Collection<String> audience) {
            return this.claim("aud", audience);
        }

        public Builder expiresAt(Instant expiresAt) {
            this.claim("exp", expiresAt);
            return this;
        }

        public Builder jti(String jti) {
            this.claim("jti", jti);
            return this;
        }

        public Builder issuedAt(Instant issuedAt) {
            this.claim("iat", issuedAt);
            return this;
        }

        public Builder issuer(String issuer) {
            this.claim("iss", issuer);
            return this;
        }

        public Builder notBefore(Instant notBefore) {
            this.claim("nbf", notBefore);
            return this;
        }

        public Builder subject(String subject) {
            this.claim("sub", subject);
            return this;
        }

        public Jwt build() {
            Instant iat = this.toInstant(this.claims.get("iat"));
            Instant exp = this.toInstant(this.claims.get("exp"));
            return new Jwt(this.tokenValue, iat, exp, this.headers, this.claims);
        }

        private Instant toInstant(Object timestamp) {
            if (timestamp != null) {
                Assert.isInstanceOf(Instant.class, timestamp, "timestamps must be of type Instant");
            }
            return (Instant)timestamp;
        }
    }
}

