/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.jwt;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidatorResult;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.util.Assert;

public final class JwtTimestampValidator
implements OAuth2TokenValidator<Jwt> {
    private final Log logger = LogFactory.getLog(this.getClass());
    private static final Duration DEFAULT_MAX_CLOCK_SKEW = Duration.of(60L, ChronoUnit.SECONDS);
    private final Duration clockSkew;
    private Clock clock = Clock.systemUTC();

    public JwtTimestampValidator() {
        this(DEFAULT_MAX_CLOCK_SKEW);
    }

    public JwtTimestampValidator(Duration clockSkew) {
        Assert.notNull((Object)clockSkew, "clockSkew cannot be null");
        this.clockSkew = clockSkew;
    }

    @Override
    public OAuth2TokenValidatorResult validate(Jwt jwt) {
        Assert.notNull((Object)jwt, "jwt cannot be null");
        Instant expiry = jwt.getExpiresAt();
        if (expiry != null && Instant.now(this.clock).minus(this.clockSkew).isAfter(expiry)) {
            OAuth2Error oAuth2Error = this.createOAuth2Error(String.format("Jwt expired at %s", jwt.getExpiresAt()));
            return OAuth2TokenValidatorResult.failure(oAuth2Error);
        }
        Instant notBefore = jwt.getNotBefore();
        if (notBefore != null && Instant.now(this.clock).plus(this.clockSkew).isBefore(notBefore)) {
            OAuth2Error oAuth2Error = this.createOAuth2Error(String.format("Jwt used before %s", jwt.getNotBefore()));
            return OAuth2TokenValidatorResult.failure(oAuth2Error);
        }
        return OAuth2TokenValidatorResult.success();
    }

    private OAuth2Error createOAuth2Error(String reason) {
        this.logger.debug(reason);
        return new OAuth2Error("invalid_token", reason, "https://tools.ietf.org/html/rfc6750#section-3.1");
    }

    public void setClock(Clock clock) {
        Assert.notNull((Object)clock, "clock cannot be null");
        this.clock = clock;
    }
}

