/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.resource;

import org.springframework.http.HttpStatus;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.util.Assert;

public final class BearerTokenError
extends OAuth2Error {
    private final HttpStatus httpStatus;
    private final String scope;

    public BearerTokenError(String errorCode, HttpStatus httpStatus, String description, String errorUri) {
        this(errorCode, httpStatus, description, errorUri, null);
    }

    public BearerTokenError(String errorCode, HttpStatus httpStatus, String description, String errorUri, String scope) {
        super(errorCode, description, errorUri);
        Assert.notNull((Object)httpStatus, "httpStatus cannot be null");
        Assert.isTrue(BearerTokenError.isDescriptionValid(description), "description contains invalid ASCII characters, it must conform to RFC 6750");
        Assert.isTrue(BearerTokenError.isErrorCodeValid(errorCode), "errorCode contains invalid ASCII characters, it must conform to RFC 6750");
        Assert.isTrue(BearerTokenError.isErrorUriValid(errorUri), "errorUri contains invalid ASCII characters, it must conform to RFC 6750");
        Assert.isTrue(BearerTokenError.isScopeValid(scope), "scope contains invalid ASCII characters, it must conform to RFC 6750");
        this.httpStatus = httpStatus;
        this.scope = scope;
    }

    public HttpStatus getHttpStatus() {
        return this.httpStatus;
    }

    public String getScope() {
        return this.scope;
    }

    private static boolean isDescriptionValid(String description) {
        return description == null || description.chars().allMatch(c -> BearerTokenError.withinTheRangeOf(c, 32, 33) || BearerTokenError.withinTheRangeOf(c, 35, 91) || BearerTokenError.withinTheRangeOf(c, 93, 126));
    }

    private static boolean isErrorCodeValid(String errorCode) {
        return errorCode.chars().allMatch(c -> BearerTokenError.withinTheRangeOf(c, 32, 33) || BearerTokenError.withinTheRangeOf(c, 35, 91) || BearerTokenError.withinTheRangeOf(c, 93, 126));
    }

    private static boolean isErrorUriValid(String errorUri) {
        return errorUri == null || errorUri.chars().allMatch(c -> c == 33 || BearerTokenError.withinTheRangeOf(c, 35, 91) || BearerTokenError.withinTheRangeOf(c, 93, 126));
    }

    private static boolean isScopeValid(String scope) {
        return scope == null || scope.chars().allMatch(c -> BearerTokenError.withinTheRangeOf(c, 32, 33) || BearerTokenError.withinTheRangeOf(c, 35, 91) || BearerTokenError.withinTheRangeOf(c, 93, 126));
    }

    private static boolean withinTheRangeOf(int c, int min, int max) {
        return c >= min && c <= max;
    }
}

