/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.resource.introspection;

import java.net.URI;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.support.BasicAuthenticationInterceptor;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.core.OAuth2AuthenticatedPrincipal;
import org.springframework.security.oauth2.core.OAuth2TokenIntrospectionClaimAccessor;
import org.springframework.security.oauth2.server.resource.introspection.BadOpaqueTokenException;
import org.springframework.security.oauth2.server.resource.introspection.OAuth2IntrospectionAuthenticatedPrincipal;
import org.springframework.security.oauth2.server.resource.introspection.OAuth2IntrospectionException;
import org.springframework.security.oauth2.server.resource.introspection.OpaqueTokenIntrospector;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

public class SpringOpaqueTokenIntrospector
implements OpaqueTokenIntrospector {
    private static final String AUTHORITY_PREFIX = "SCOPE_";
    private static final ParameterizedTypeReference<Map<String, Object>> STRING_OBJECT_MAP = new ParameterizedTypeReference<Map<String, Object>>(){};
    private final Log logger = LogFactory.getLog(this.getClass());
    private final RestOperations restOperations;
    private Converter<String, RequestEntity<?>> requestEntityConverter;
    private Converter<OAuth2TokenIntrospectionClaimAccessor, ? extends OAuth2AuthenticatedPrincipal> authenticationConverter = this::defaultAuthenticationConverter;

    public SpringOpaqueTokenIntrospector(String introspectionUri, String clientId, String clientSecret) {
        Assert.notNull((Object)introspectionUri, "introspectionUri cannot be null");
        Assert.notNull((Object)clientId, "clientId cannot be null");
        Assert.notNull((Object)clientSecret, "clientSecret cannot be null");
        this.requestEntityConverter = this.defaultRequestEntityConverter(URI.create(introspectionUri));
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.getInterceptors().add(new BasicAuthenticationInterceptor(clientId, clientSecret));
        this.restOperations = restTemplate;
    }

    public SpringOpaqueTokenIntrospector(String introspectionUri, RestOperations restOperations) {
        Assert.notNull((Object)introspectionUri, "introspectionUri cannot be null");
        Assert.notNull((Object)restOperations, "restOperations cannot be null");
        this.requestEntityConverter = this.defaultRequestEntityConverter(URI.create(introspectionUri));
        this.restOperations = restOperations;
    }

    private Converter<String, RequestEntity<?>> defaultRequestEntityConverter(URI introspectionUri) {
        return token -> {
            HttpHeaders headers = this.requestHeaders();
            MultiValueMap<String, String> body2 = this.requestBody((String)token);
            return new RequestEntity<MultiValueMap<String, String>>(body2, headers, HttpMethod.POST, introspectionUri);
        };
    }

    private HttpHeaders requestHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        return headers;
    }

    private MultiValueMap<String, String> requestBody(String token) {
        LinkedMultiValueMap<String, String> body2 = new LinkedMultiValueMap<String, String>();
        body2.add("token", token);
        return body2;
    }

    @Override
    public OAuth2AuthenticatedPrincipal introspect(String token) {
        RequestEntity<?> requestEntity = this.requestEntityConverter.convert(token);
        if (requestEntity == null) {
            throw new OAuth2IntrospectionException("requestEntityConverter returned a null entity");
        }
        ResponseEntity<Map<String, Object>> responseEntity = this.makeRequest(requestEntity);
        Map<String, Object> claims = this.adaptToNimbusResponse(responseEntity);
        ArrayListFromStringClaimAccessor accessor = this.convertClaimsSet(claims);
        return this.authenticationConverter.convert(accessor);
    }

    public void setRequestEntityConverter(Converter<String, RequestEntity<?>> requestEntityConverter) {
        Assert.notNull(requestEntityConverter, "requestEntityConverter cannot be null");
        this.requestEntityConverter = requestEntityConverter;
    }

    private ResponseEntity<Map<String, Object>> makeRequest(RequestEntity<?> requestEntity) {
        try {
            return this.restOperations.exchange(requestEntity, STRING_OBJECT_MAP);
        }
        catch (Exception ex) {
            throw new OAuth2IntrospectionException(ex.getMessage(), ex);
        }
    }

    private Map<String, Object> adaptToNimbusResponse(ResponseEntity<Map<String, Object>> responseEntity) {
        if (responseEntity.getStatusCode() != HttpStatus.OK) {
            throw new OAuth2IntrospectionException("Introspection endpoint responded with " + responseEntity.getStatusCode());
        }
        Map claims = (Map)responseEntity.getBody();
        if (claims == null) {
            return Collections.emptyMap();
        }
        boolean active = (Boolean)claims.compute("active", (k, v) -> {
            if (v instanceof String) {
                return Boolean.parseBoolean((String)v);
            }
            if (v instanceof Boolean) {
                return v;
            }
            return false;
        });
        if (!active) {
            this.logger.trace("Did not validate token since it is inactive");
            throw new BadOpaqueTokenException("Provided token isn't active");
        }
        return claims;
    }

    private ArrayListFromStringClaimAccessor convertClaimsSet(Map<String, Object> claims) {
        LinkedHashMap<String, Object> converted = new LinkedHashMap<String, Object>(claims);
        converted.computeIfPresent("aud", (k, v) -> {
            if (v instanceof String) {
                return Collections.singletonList(v);
            }
            return v;
        });
        converted.computeIfPresent("client_id", (k, v) -> v.toString());
        converted.computeIfPresent("exp", (k, v) -> Instant.ofEpochSecond(((Number)v).longValue()));
        converted.computeIfPresent("iat", (k, v) -> Instant.ofEpochSecond(((Number)v).longValue()));
        converted.computeIfPresent("iss", (k, v) -> v.toString());
        converted.computeIfPresent("nbf", (k, v) -> Instant.ofEpochSecond(((Number)v).longValue()));
        converted.computeIfPresent("scope", (k, v) -> {
            Object object;
            if (v instanceof String) {
                String s = (String)v;
                object = new ArrayListFromString(s.split(" "));
            } else {
                object = v;
            }
            return object;
        });
        return () -> converted;
    }

    public void setAuthenticationConverter(Converter<OAuth2TokenIntrospectionClaimAccessor, ? extends OAuth2AuthenticatedPrincipal> authenticationConverter) {
        Assert.notNull(authenticationConverter, "converter cannot be null");
        this.authenticationConverter = authenticationConverter;
    }

    private OAuth2IntrospectionAuthenticatedPrincipal defaultAuthenticationConverter(OAuth2TokenIntrospectionClaimAccessor accessor) {
        Collection<GrantedAuthority> authorities = this.authorities(accessor.getScopes());
        return new OAuth2IntrospectionAuthenticatedPrincipal(accessor.getClaims(), authorities);
    }

    private Collection<GrantedAuthority> authorities(List<String> scopes) {
        if (!(scopes instanceof ArrayListFromString)) {
            return Collections.emptyList();
        }
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        for (String scope : scopes) {
            authorities.add(new SimpleGrantedAuthority(AUTHORITY_PREFIX + scope));
        }
        return authorities;
    }

    private static interface ArrayListFromStringClaimAccessor
    extends OAuth2TokenIntrospectionClaimAccessor {
        @Override
        default public List<String> getScopes() {
            Object value = this.getClaims().get("scope");
            if (value instanceof ArrayListFromString) {
                ArrayListFromString list = (ArrayListFromString)value;
                return list;
            }
            return OAuth2TokenIntrospectionClaimAccessor.super.getScopes();
        }
    }

    private static final class ArrayListFromString
    extends ArrayList<String> {
        ArrayListFromString(String ... elements) {
            super(Arrays.asList(elements));
        }
    }
}

