/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.access.intercept;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogMessage;
import org.springframework.security.authorization.AuthenticatedAuthorizationManager;
import org.springframework.security.authorization.AuthorityAuthorizationManager;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.access.intercept.RequestAuthorizationContext;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcherEntry;
import org.springframework.util.Assert;

public final class RequestMatcherDelegatingAuthorizationManager
implements AuthorizationManager<HttpServletRequest> {
    private static final AuthorizationDecision DENY = new AuthorizationDecision(false);
    private final Log logger = LogFactory.getLog(this.getClass());
    private final List<RequestMatcherEntry<AuthorizationManager<RequestAuthorizationContext>>> mappings;

    private RequestMatcherDelegatingAuthorizationManager(List<RequestMatcherEntry<AuthorizationManager<RequestAuthorizationContext>>> mappings) {
        Assert.notEmpty(mappings, "mappings cannot be empty");
        this.mappings = mappings;
    }

    @Override
    public AuthorizationDecision check(Supplier<Authentication> authentication, HttpServletRequest request) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(LogMessage.format("Authorizing %s", (Object)RequestMatcherDelegatingAuthorizationManager.requestLine(request)));
        }
        for (RequestMatcherEntry<AuthorizationManager<RequestAuthorizationContext>> mapping : this.mappings) {
            RequestMatcher matcher = mapping.getRequestMatcher();
            RequestMatcher.MatchResult matchResult = matcher.matcher(request);
            if (!matchResult.isMatch()) continue;
            AuthorizationManager<RequestAuthorizationContext> manager = mapping.getEntry();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(LogMessage.format("Checking authorization on %s using %s", (Object)RequestMatcherDelegatingAuthorizationManager.requestLine(request), manager));
            }
            return manager.check(authentication, new RequestAuthorizationContext(request, matchResult.getVariables()));
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(LogMessage.of(() -> "Denying request since did not find matching RequestMatcher"));
        }
        return DENY;
    }

    private static String requestLine(HttpServletRequest request) {
        return request.getMethod() + " " + UrlUtils.buildRequestUrl(request);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private boolean anyRequestConfigured;
        private final List<RequestMatcherEntry<AuthorizationManager<RequestAuthorizationContext>>> mappings = new ArrayList<RequestMatcherEntry<AuthorizationManager<RequestAuthorizationContext>>>();

        public Builder add(RequestMatcher matcher, AuthorizationManager<RequestAuthorizationContext> manager) {
            Assert.state(!this.anyRequestConfigured, "Can't add mappings after anyRequest");
            Assert.notNull((Object)matcher, "matcher cannot be null");
            Assert.notNull(manager, "manager cannot be null");
            this.mappings.add(new RequestMatcherEntry<AuthorizationManager<RequestAuthorizationContext>>(matcher, manager));
            return this;
        }

        public Builder mappings(Consumer<List<RequestMatcherEntry<AuthorizationManager<RequestAuthorizationContext>>>> mappingsConsumer) {
            Assert.state(!this.anyRequestConfigured, "Can't configure mappings after anyRequest");
            Assert.notNull(mappingsConsumer, "mappingsConsumer cannot be null");
            mappingsConsumer.accept(this.mappings);
            return this;
        }

        public AuthorizedUrl anyRequest() {
            Assert.state(!this.anyRequestConfigured, "Can't configure anyRequest after itself");
            this.anyRequestConfigured = true;
            return new AuthorizedUrl(AnyRequestMatcher.INSTANCE);
        }

        public AuthorizedUrl requestMatchers(RequestMatcher ... matchers) {
            Assert.state(!this.anyRequestConfigured, "Can't configure requestMatchers after anyRequest");
            return new AuthorizedUrl(matchers);
        }

        public RequestMatcherDelegatingAuthorizationManager build() {
            return new RequestMatcherDelegatingAuthorizationManager(this.mappings);
        }

        public final class AuthorizedUrl {
            private final List<RequestMatcher> matchers;

            private AuthorizedUrl(RequestMatcher ... matchers) {
                this(List.of(matchers));
            }

            private AuthorizedUrl(List<RequestMatcher> matchers) {
                this.matchers = matchers;
            }

            public Builder permitAll() {
                return this.access((a, o) -> new AuthorizationDecision(true));
            }

            public Builder denyAll() {
                return this.access((a, o) -> new AuthorizationDecision(false));
            }

            public Builder authenticated() {
                return this.access(AuthenticatedAuthorizationManager.authenticated());
            }

            public Builder fullyAuthenticated() {
                return this.access(AuthenticatedAuthorizationManager.fullyAuthenticated());
            }

            public Builder rememberMe() {
                return this.access(AuthenticatedAuthorizationManager.rememberMe());
            }

            public Builder anonymous() {
                return this.access(AuthenticatedAuthorizationManager.anonymous());
            }

            public Builder hasRole(String role) {
                return this.access(AuthorityAuthorizationManager.hasRole(role));
            }

            public Builder hasAnyRole(String ... roles) {
                return this.access(AuthorityAuthorizationManager.hasAnyRole(roles));
            }

            public Builder hasAuthority(String authority) {
                return this.access(AuthorityAuthorizationManager.hasAuthority(authority));
            }

            public Builder hasAnyAuthority(String ... authorities) {
                return this.access(AuthorityAuthorizationManager.hasAnyAuthority(authorities));
            }

            private Builder access(AuthorizationManager<RequestAuthorizationContext> manager) {
                for (RequestMatcher matcher : this.matchers) {
                    Builder.this.mappings.add(new RequestMatcherEntry<AuthorizationManager<RequestAuthorizationContext>>(matcher, manager));
                }
                return Builder.this;
            }
        }
    }
}

