/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.util.Assert;

public final class DelegatingAuthenticationConverter
implements AuthenticationConverter {
    private final List<AuthenticationConverter> delegates;

    public DelegatingAuthenticationConverter(List<AuthenticationConverter> delegates) {
        Assert.notEmpty(delegates, "delegates cannot be null");
        this.delegates = new ArrayList<AuthenticationConverter>(delegates);
    }

    public DelegatingAuthenticationConverter(AuthenticationConverter ... delegates) {
        Assert.notEmpty((Object[])delegates, "delegates cannot be null");
        this.delegates = List.of(delegates);
    }

    @Override
    public Authentication convert(HttpServletRequest request) {
        for (AuthenticationConverter delegate : this.delegates) {
            Authentication authentication = delegate.convert(request);
            if (authentication == null) continue;
            return authentication;
        }
        return null;
    }
}

