/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.logout;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public class DelegatingLogoutSuccessHandler
implements LogoutSuccessHandler {
    private final LinkedHashMap<RequestMatcher, LogoutSuccessHandler> matcherToHandler;
    private LogoutSuccessHandler defaultLogoutSuccessHandler;

    public DelegatingLogoutSuccessHandler(LinkedHashMap<RequestMatcher, LogoutSuccessHandler> matcherToHandler) {
        Assert.notEmpty(matcherToHandler, "matcherToHandler cannot be null");
        this.matcherToHandler = matcherToHandler;
    }

    @Override
    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        for (Map.Entry<RequestMatcher, LogoutSuccessHandler> entry : this.matcherToHandler.entrySet()) {
            RequestMatcher matcher = entry.getKey();
            if (!matcher.matches(request)) continue;
            LogoutSuccessHandler handler = entry.getValue();
            handler.onLogoutSuccess(request, response, authentication);
            return;
        }
        if (this.defaultLogoutSuccessHandler != null) {
            this.defaultLogoutSuccessHandler.onLogoutSuccess(request, response, authentication);
        }
    }

    public void setDefaultLogoutSuccessHandler(LogoutSuccessHandler defaultLogoutSuccessHandler) {
        this.defaultLogoutSuccessHandler = defaultLogoutSuccessHandler;
    }
}

