/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.springframework.lang.Nullable;
import org.springframework.security.web.server.WebFilterChainProxy;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import org.springframework.web.server.WebHandler;
import reactor.core.publisher.Mono;

public final class ObservationWebFilterChainDecorator
implements WebFilterChainProxy.WebFilterChainDecorator {
    private static final String ATTRIBUTE = ObservationWebFilterChainDecorator.class + ".observation";
    static final String UNSECURED_OBSERVATION_NAME = "spring.security.http.unsecured.requests";
    static final String SECURED_OBSERVATION_NAME = "spring.security.http.secured.requests";
    private final ObservationRegistry registry;

    public ObservationWebFilterChainDecorator(ObservationRegistry registry) {
        this.registry = registry;
    }

    @Override
    public WebFilterChain decorate(WebFilterChain original) {
        return this.wrapUnsecured(original);
    }

    @Override
    public WebFilterChain decorate(WebFilterChain original, List<WebFilter> filters) {
        return new ObservationWebFilterChain(this.wrapSecured(original)::filter, this.wrap(filters));
    }

    private static AroundWebFilterObservation observation(ServerWebExchange exchange2) {
        return (AroundWebFilterObservation)exchange2.getAttribute(ATTRIBUTE);
    }

    private WebFilterChain wrapSecured(WebFilterChain original) {
        return exchange2 -> Mono.deferContextual(contextView -> {
            AroundWebFilterObservation parent = ObservationWebFilterChainDecorator.observation(exchange2);
            Observation parentObservation = (Observation)contextView.getOrDefault((Object)"micrometer.observation", null);
            Observation observation = Observation.createNotStarted(SECURED_OBSERVATION_NAME, this.registry).contextualName("secured request").parentObservation(parentObservation);
            return parent.wrap(WebFilterObservation.create(observation).wrap(original)).filter(exchange2);
        });
    }

    private WebFilterChain wrapUnsecured(WebFilterChain original) {
        return exchange2 -> Mono.deferContextual(contextView -> {
            Observation parentObservation = (Observation)contextView.getOrDefault((Object)"micrometer.observation", null);
            Observation observation = Observation.createNotStarted(UNSECURED_OBSERVATION_NAME, this.registry).contextualName("unsecured request").parentObservation(parentObservation);
            return WebFilterObservation.create(observation).wrap(original).filter(exchange2);
        });
    }

    private List<ObservationWebFilter> wrap(List<WebFilter> filters) {
        int size = filters.size();
        ArrayList<ObservationWebFilter> observableFilters = new ArrayList<ObservationWebFilter>();
        int position = 1;
        for (WebFilter filter2 : filters) {
            observableFilters.add(new ObservationWebFilter(this.registry, filter2, position, size));
            ++position;
        }
        return observableFilters;
    }

    static class ObservationWebFilterChain
    implements WebFilterChain {
        private final WebHandler handler;
        @Nullable
        private final ObservationWebFilter currentFilter;
        @Nullable
        private final ObservationWebFilterChain chain;

        ObservationWebFilterChain(WebHandler handler, List<ObservationWebFilter> filters) {
            Assert.notNull((Object)handler, "WebHandler is required");
            this.handler = handler;
            ObservationWebFilterChain chain = ObservationWebFilterChain.initChain(filters, handler);
            this.currentFilter = chain.currentFilter;
            this.chain = chain.chain;
        }

        private static ObservationWebFilterChain initChain(List<ObservationWebFilter> filters, WebHandler handler) {
            ObservationWebFilterChain chain = new ObservationWebFilterChain(handler, null, null);
            ListIterator<ObservationWebFilter> iterator = filters.listIterator(filters.size());
            while (iterator.hasPrevious()) {
                chain = new ObservationWebFilterChain(handler, iterator.previous(), chain);
            }
            return chain;
        }

        private ObservationWebFilterChain(WebHandler handler, @Nullable ObservationWebFilter currentFilter, @Nullable ObservationWebFilterChain chain) {
            this.currentFilter = currentFilter;
            this.handler = handler;
            this.chain = chain;
        }

        @Override
        public Mono<Void> filter(ServerWebExchange exchange2) {
            return Mono.defer(() -> this.currentFilter != null && this.chain != null ? this.invokeFilter(this.currentFilter, this.chain, exchange2) : this.handler.handle(exchange2));
        }

        private Mono<Void> invokeFilter(ObservationWebFilter current, ObservationWebFilterChain chain, ServerWebExchange exchange2) {
            String currentName = current.getName();
            return current.filter(exchange2, chain).checkpoint(currentName + " [DefaultWebFilterChain]");
        }
    }

    static interface AroundWebFilterObservation
    extends WebFilterObservation {
        public static final AroundWebFilterObservation NOOP = new AroundWebFilterObservation(){};

        public static AroundWebFilterObservation create(Observation before, Observation after) {
            if (before.isNoop() || after.isNoop()) {
                return NOOP;
            }
            return new SimpleAroundWebFilterObservation(before, after);
        }

        default public Observation before() {
            return Observation.NOOP;
        }

        default public Observation after() {
            return Observation.NOOP;
        }

        public static class SimpleAroundWebFilterObservation
        implements AroundWebFilterObservation {
            private final Object lock = new Object();
            private final PhasedObservation before;
            private final PhasedObservation after;
            private volatile PhasedObservation currentObservation = PhasedObservation.NOOP;

            SimpleAroundWebFilterObservation(Observation before, Observation after) {
                this.before = new PhasedObservation(before);
                this.after = new PhasedObservation(after);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Observation start() {
                Object object = this.lock;
                synchronized (object) {
                    if (this.currentObservation == PhasedObservation.NOOP) {
                        this.before.start();
                        this.currentObservation = this.before;
                        return this.currentObservation;
                    }
                    if (this.currentObservation == this.before) {
                        this.before.stop();
                        this.after.start();
                        this.currentObservation = this.after;
                        return this.currentObservation;
                    }
                }
                return Observation.NOOP;
            }

            @Override
            public Observation error(Throwable ex) {
                this.currentObservation.error(ex);
                return this.currentObservation.observation;
            }

            @Override
            public void stop() {
                this.before.stop();
                this.after.stop();
            }

            private void close() {
                this.before.close();
                this.after.close();
            }

            @Override
            public Observation contextualName(String contextualName) {
                return this.currentObservation.observation.contextualName(contextualName);
            }

            @Override
            public Observation parentObservation(Observation parentObservation) {
                return this.currentObservation.observation.parentObservation(parentObservation);
            }

            @Override
            public Observation lowCardinalityKeyValue(KeyValue keyValue) {
                return this.currentObservation.observation.lowCardinalityKeyValue(keyValue);
            }

            @Override
            public Observation highCardinalityKeyValue(KeyValue keyValue) {
                return this.currentObservation.observation.highCardinalityKeyValue(keyValue);
            }

            @Override
            public Observation observationConvention(ObservationConvention<?> observationConvention) {
                return this.currentObservation.observation.observationConvention(observationConvention);
            }

            @Override
            public Observation event(Observation.Event event) {
                return this.currentObservation.observation.event(event);
            }

            @Override
            public Observation.Context getContext() {
                return this.currentObservation.observation.getContext();
            }

            @Override
            public Observation.Scope openScope() {
                return this.currentObservation.observation.openScope();
            }

            @Override
            public WebFilterChain wrap(WebFilterChain chain) {
                return exchange2 -> {
                    this.stop();
                    return chain.filter(exchange2).doOnSuccess(v -> this.start()).doOnCancel(this::start).doOnError(t -> {
                        this.error((Throwable)t);
                        this.start();
                    });
                };
            }

            @Override
            public WebFilter wrap(WebFilter filter2) {
                return (exchange2, chain) -> {
                    this.start();
                    return filter2.filter(exchange2, chain).doOnSuccess(v -> this.close()).doOnCancel(this::close).doOnError(t -> {
                        this.error((Throwable)t);
                        this.close();
                    }).contextWrite(context -> context.put((Object)"micrometer.observation", (Object)this));
                };
            }

            @Override
            public Observation before() {
                return this.before.observation;
            }

            @Override
            public Observation after() {
                return this.after.observation;
            }

            public String toString() {
                return this.currentObservation.observation.toString();
            }
        }
    }

    static final class ObservationWebFilter
    implements WebFilter {
        private final ObservationRegistry registry;
        private final WebFilterChainObservationConvention convention = new WebFilterChainObservationConvention();
        private final WebFilter filter;
        private final String name;
        private final int position;
        private final int size;

        ObservationWebFilter(ObservationRegistry registry, WebFilter filter2, int position, int size) {
            this.registry = registry;
            this.filter = filter2;
            this.name = filter2.getClass().getSimpleName();
            this.position = position;
            this.size = size;
        }

        String getName() {
            return this.name;
        }

        @Override
        public Mono<Void> filter(ServerWebExchange exchange2, WebFilterChain chain) {
            if (this.position == 1) {
                return Mono.deferContextual(contextView -> {
                    Observation parentObservation = (Observation)contextView.getOrDefault((Object)"micrometer.observation", null);
                    AroundWebFilterObservation parent = this.parent(exchange2, parentObservation);
                    return parent.wrap(this::wrapFilter).filter(exchange2, chain);
                });
            }
            return this.wrapFilter(exchange2, chain);
        }

        private Mono<Void> wrapFilter(ServerWebExchange exchange2, WebFilterChain chain) {
            AroundWebFilterObservation parent = ObservationWebFilterChainDecorator.observation(exchange2);
            Observation.Context context = parent.before().getContext();
            if (context instanceof WebFilterChainObservationContext) {
                WebFilterChainObservationContext parentBefore = (WebFilterChainObservationContext)context;
                parentBefore.setChainSize(this.size);
                parentBefore.setFilterName(this.name);
                parentBefore.setChainPosition(this.position);
            }
            return this.filter.filter(exchange2, chain).doOnSuccess(result -> {
                parent.start();
                Observation.Context patt7764$temp = parent.after().getContext();
                if (patt7764$temp instanceof WebFilterChainObservationContext) {
                    WebFilterChainObservationContext parentAfter = (WebFilterChainObservationContext)patt7764$temp;
                    parentAfter.setChainSize(this.size);
                    parentAfter.setFilterName(this.name);
                    parentAfter.setChainPosition(this.size - this.position + 1);
                }
            });
        }

        private AroundWebFilterObservation parent(ServerWebExchange exchange2, Observation parentObservation) {
            WebFilterChainObservationContext beforeContext = WebFilterChainObservationContext.before();
            WebFilterChainObservationContext afterContext = WebFilterChainObservationContext.after();
            Observation before = Observation.createNotStarted(this.convention, () -> beforeContext, this.registry).parentObservation(parentObservation);
            Observation after = Observation.createNotStarted(this.convention, () -> afterContext, this.registry).parentObservation(parentObservation);
            AroundWebFilterObservation parent = AroundWebFilterObservation.create(before, after);
            exchange2.getAttributes().put(ATTRIBUTE, parent);
            return parent;
        }
    }

    static interface WebFilterObservation
    extends Observation {
        public static final WebFilterObservation NOOP = new WebFilterObservation(){};

        public static WebFilterObservation create(Observation observation) {
            if (observation.isNoop()) {
                return NOOP;
            }
            return new SimpleWebFilterObservation(observation);
        }

        @Override
        default public Observation contextualName(String contextualName) {
            return Observation.NOOP;
        }

        @Override
        default public Observation parentObservation(Observation parentObservation) {
            return Observation.NOOP;
        }

        @Override
        default public Observation lowCardinalityKeyValue(KeyValue keyValue) {
            return Observation.NOOP;
        }

        @Override
        default public Observation highCardinalityKeyValue(KeyValue keyValue) {
            return Observation.NOOP;
        }

        @Override
        default public Observation observationConvention(ObservationConvention<?> observationConvention) {
            return Observation.NOOP;
        }

        @Override
        default public Observation error(Throwable error) {
            return Observation.NOOP;
        }

        @Override
        default public Observation event(Observation.Event event) {
            return Observation.NOOP;
        }

        @Override
        default public Observation start() {
            return Observation.NOOP;
        }

        @Override
        default public Observation.Context getContext() {
            return new Observation.Context();
        }

        @Override
        default public void stop() {
        }

        @Override
        default public Observation.Scope openScope() {
            return Observation.Scope.NOOP;
        }

        default public WebFilter wrap(WebFilter filter2) {
            return filter2;
        }

        default public WebFilterChain wrap(WebFilterChain chain) {
            return chain;
        }

        public static class SimpleWebFilterObservation
        implements WebFilterObservation {
            private final PhasedObservation observation;

            SimpleWebFilterObservation(Observation observation) {
                this.observation = new PhasedObservation(observation);
            }

            @Override
            public Observation start() {
                return this.observation.start();
            }

            @Override
            public Observation error(Throwable ex) {
                return this.observation.error(ex);
            }

            @Override
            public void stop() {
                this.observation.stop();
            }

            @Override
            public Observation contextualName(String contextualName) {
                return this.observation.contextualName(contextualName);
            }

            @Override
            public Observation parentObservation(Observation parentObservation) {
                return this.observation.parentObservation(parentObservation);
            }

            @Override
            public Observation lowCardinalityKeyValue(KeyValue keyValue) {
                return this.observation.lowCardinalityKeyValue(keyValue);
            }

            @Override
            public Observation highCardinalityKeyValue(KeyValue keyValue) {
                return this.observation.highCardinalityKeyValue(keyValue);
            }

            @Override
            public Observation observationConvention(ObservationConvention<?> observationConvention) {
                return this.observation.observationConvention(observationConvention);
            }

            @Override
            public Observation event(Observation.Event event) {
                return this.observation.event(event);
            }

            @Override
            public Observation.Context getContext() {
                return this.observation.getContext();
            }

            @Override
            public Observation.Scope openScope() {
                return this.observation.openScope();
            }

            @Override
            public WebFilter wrap(WebFilter filter2) {
                if (this.observation.isNoop()) {
                    return filter2;
                }
                return (exchange2, chain) -> {
                    this.observation.start();
                    return filter2.filter(exchange2, chain).doOnSuccess(v -> this.observation.stop()).doOnCancel(this.observation::stop).doOnError(t -> {
                        this.observation.error((Throwable)t);
                        this.observation.stop();
                    });
                };
            }

            @Override
            public WebFilterChain wrap(WebFilterChain chain) {
                if (this.observation.isNoop()) {
                    return chain;
                }
                return exchange2 -> {
                    this.observation.start();
                    return chain.filter(exchange2).doOnSuccess(v -> this.observation.stop()).doOnCancel(this.observation::stop).doOnError(t -> {
                        this.observation.error((Throwable)t);
                        this.observation.stop();
                    }).contextWrite(context -> context.put((Object)"micrometer.observation", (Object)this.observation));
                };
            }
        }
    }

    private static final class PhasedObservation
    implements Observation {
        private static final PhasedObservation NOOP = new PhasedObservation(Observation.NOOP);
        private final Object lock = new Object();
        private volatile int phase = 0;
        private final Observation observation;

        private PhasedObservation(Observation observation) {
            this.observation = observation;
        }

        @Override
        public Observation contextualName(String contextualName) {
            return this.observation.contextualName(contextualName);
        }

        @Override
        public Observation parentObservation(Observation parentObservation) {
            return this.observation.parentObservation(parentObservation);
        }

        @Override
        public Observation lowCardinalityKeyValue(KeyValue keyValue) {
            return this.observation.lowCardinalityKeyValue(keyValue);
        }

        @Override
        public Observation highCardinalityKeyValue(KeyValue keyValue) {
            return this.observation.highCardinalityKeyValue(keyValue);
        }

        @Override
        public Observation observationConvention(ObservationConvention<?> observationConvention) {
            return this.observation.observationConvention(observationConvention);
        }

        @Override
        public Observation event(Observation.Event event) {
            return this.observation.event(event);
        }

        @Override
        public Observation.Context getContext() {
            return this.observation.getContext();
        }

        @Override
        public Observation.Scope openScope() {
            return this.observation.openScope();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PhasedObservation start() {
            Object object = this.lock;
            synchronized (object) {
                if (this.phase == 0) {
                    this.observation.start();
                    this.phase = 1;
                }
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PhasedObservation error(Throwable ex) {
            Object object = this.lock;
            synchronized (object) {
                if (this.phase == 1) {
                    this.observation.error(ex);
                }
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stop() {
            Object object = this.lock;
            synchronized (object) {
                if (this.phase == 1) {
                    this.observation.stop();
                    this.phase = 2;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() {
            Object object = this.lock;
            synchronized (object) {
                if (this.phase == 1) {
                    this.observation.stop();
                }
                this.phase = 3;
            }
        }
    }

    static final class WebFilterChainObservationConvention
    implements ObservationConvention<WebFilterChainObservationContext> {
        static final String CHAIN_OBSERVATION_NAME = "spring.security.filterchains";
        private static final String CHAIN_POSITION_NAME = "spring.security.filterchain.position";
        private static final String CHAIN_SIZE_NAME = "spring.security.filterchain.size";
        private static final String FILTER_SECTION_NAME = "spring.security.reached.filter.section";
        private static final String FILTER_NAME = "spring.security.reached.filter.name";

        WebFilterChainObservationConvention() {
        }

        @Override
        public String getName() {
            return CHAIN_OBSERVATION_NAME;
        }

        @Override
        public String getContextualName(WebFilterChainObservationContext context) {
            return "security filterchain " + context.getFilterSection();
        }

        @Override
        public KeyValues getLowCardinalityKeyValues(WebFilterChainObservationContext context) {
            return KeyValues.of(CHAIN_SIZE_NAME, String.valueOf(context.getChainSize())).and(CHAIN_POSITION_NAME, String.valueOf(context.getChainPosition())).and(FILTER_SECTION_NAME, context.getFilterSection()).and(FILTER_NAME, StringUtils.hasText(context.getFilterName()) ? context.getFilterName() : "none");
        }

        @Override
        public boolean supportsContext(Observation.Context context) {
            return context instanceof WebFilterChainObservationContext;
        }
    }

    static final class WebFilterChainObservationContext
    extends Observation.Context {
        private final String filterSection;
        private String filterName;
        private int chainPosition;
        private int chainSize;

        private WebFilterChainObservationContext(String filterSection) {
            this.filterSection = filterSection;
        }

        static WebFilterChainObservationContext before() {
            return new WebFilterChainObservationContext("before");
        }

        static WebFilterChainObservationContext after() {
            return new WebFilterChainObservationContext("after");
        }

        String getFilterSection() {
            return this.filterSection;
        }

        String getFilterName() {
            return this.filterName;
        }

        void setFilterName(String filterName) {
            this.filterName = filterName;
        }

        int getChainPosition() {
            return this.chainPosition;
        }

        void setChainPosition(int chainPosition) {
            this.chainPosition = chainPosition;
        }

        int getChainSize() {
            return this.chainSize;
        }

        void setChainSize(int chainSize) {
            this.chainSize = chainSize;
        }
    }
}

