/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.authentication;

import java.util.List;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.server.authentication.ServerAuthenticationConverter;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class DelegatingServerAuthenticationConverter
implements ServerAuthenticationConverter {
    private final List<ServerAuthenticationConverter> delegates;
    private boolean continueOnError = false;
    private final Log logger = LogFactory.getLog(this.getClass());

    public DelegatingServerAuthenticationConverter(ServerAuthenticationConverter ... converters) {
        this(List.of(converters));
    }

    public DelegatingServerAuthenticationConverter(List<ServerAuthenticationConverter> converters) {
        Assert.notEmpty(converters, "converters cannot be null");
        this.delegates = converters;
    }

    @Override
    public Mono<Authentication> convert(ServerWebExchange exchange2) {
        Flux result = Flux.fromIterable(this.delegates);
        Function<ServerAuthenticationConverter, Mono> logging = converter -> converter.convert(exchange2).doOnError(this.logger::debug);
        return (this.continueOnError ? result.concatMapDelayError(logging) : result.concatMap(logging)).next();
    }

    public void setContinueOnError(boolean continueOnError) {
        this.continueOnError = continueOnError;
    }
}

