/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.authentication;

import org.springframework.security.core.Authentication;
import org.springframework.security.core.session.ReactiveSessionInformation;
import org.springframework.security.core.session.ReactiveSessionRegistry;
import org.springframework.security.web.server.WebFilterExchange;
import org.springframework.security.web.server.authentication.ServerAuthenticationSuccessHandler;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public final class RegisterSessionServerAuthenticationSuccessHandler
implements ServerAuthenticationSuccessHandler {
    private final ReactiveSessionRegistry sessionRegistry;

    public RegisterSessionServerAuthenticationSuccessHandler(ReactiveSessionRegistry sessionRegistry) {
        Assert.notNull((Object)sessionRegistry, "sessionRegistry cannot be null");
        this.sessionRegistry = sessionRegistry;
    }

    @Override
    public Mono<Void> onAuthenticationSuccess(WebFilterExchange exchange2, Authentication authentication) {
        return exchange2.getExchange().getSession().map(session -> new ReactiveSessionInformation(authentication.getPrincipal(), session.getId(), session.getLastAccessTime())).flatMap(this.sessionRegistry::saveSessionInformation);
    }
}

