/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.spi.EndpointStrategy;
import org.apache.camel.spi.InterceptSendToEndpoint;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.util.URISupport;

public class InterceptSendToEndpointCallback
implements EndpointStrategy {
    private final CamelContext camelContext;
    private final Processor before;
    private final Processor after;
    private final String matchURI;
    private final boolean skip;

    public InterceptSendToEndpointCallback(CamelContext camelContext, Processor before, Processor after, String matchURI, boolean skip) {
        this.camelContext = camelContext;
        this.before = before;
        this.after = after;
        this.matchURI = matchURI;
        this.skip = skip;
    }

    @Override
    public Endpoint registerEndpoint(String uri, Endpoint endpoint) {
        if (endpoint instanceof InterceptSendToEndpoint) {
            return endpoint;
        }
        if (this.matchURI == null || this.matchPattern(uri, this.matchURI)) {
            return PluginHelper.getInterceptEndpointFactory(this.camelContext).createInterceptSendToEndpoint(this.camelContext, endpoint, this.skip, this.before, this.after);
        }
        return endpoint;
    }

    protected boolean matchPattern(String uri, String pattern) {
        boolean match = EndpointHelper.matchEndpoint(this.camelContext, uri, pattern);
        if (!match) {
            try {
                pattern = URISupport.normalizeUri(pattern);
                match = EndpointHelper.matchEndpoint(this.camelContext, uri, pattern);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return match;
    }
}

