/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx;

import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.impl.VertxBuilder;
import org.apache.camel.CamelContext;
import org.apache.camel.component.vertx.VertxComponent;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class VertxComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        VertxComponent target = (VertxComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled(VertxComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler(VertxComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "host": {
                target.setHost(VertxComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(VertxComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "port": {
                target.setPort(VertxComponentConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "timeout": {
                target.setTimeout(VertxComponentConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "vertx": {
                target.setVertx(VertxComponentConfigurer.property(camelContext, Vertx.class, value));
                return true;
            }
            case "vertxfactory": 
            case "vertxFactory": {
                target.setVertxFactory(VertxComponentConfigurer.property(camelContext, VertxBuilder.class, value));
                return true;
            }
            case "vertxoptions": 
            case "vertxOptions": {
                target.setVertxOptions(VertxComponentConfigurer.property(camelContext, VertxOptions.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public String[] getAutowiredNames() {
        return new String[]{"vertx"};
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "host": {
                return String.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "port": {
                return Integer.TYPE;
            }
            case "timeout": {
                return Integer.TYPE;
            }
            case "vertx": {
                return Vertx.class;
            }
            case "vertxfactory": 
            case "vertxFactory": {
                return VertxBuilder.class;
            }
            case "vertxoptions": 
            case "vertxOptions": {
                return VertxOptions.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        VertxComponent target = (VertxComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "host": {
                return target.getHost();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "port": {
                return target.getPort();
            }
            case "timeout": {
                return target.getTimeout();
            }
            case "vertx": {
                return target.getVertx();
            }
            case "vertxfactory": 
            case "vertxFactory": {
                return target.getVertxFactory();
            }
            case "vertxoptions": 
            case "vertxOptions": {
                return target.getVertxOptions();
            }
        }
        return null;
    }
}

