/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx.common;

import io.netty.buffer.ByteBuf;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.Exchange;
import org.apache.camel.StreamCache;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.vertx.common.VertxBufferConverter;
import org.apache.camel.component.vertx.common.VertxJsonArrayConverter;
import org.apache.camel.component.vertx.common.VertxJsonObjectConverter;
import org.apache.camel.spi.BulkTypeConverters;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.spi.TypeConvertible;

@DeferredContextBinding
public final class CamelVertxCommonBulkConverterLoader
implements TypeConverterLoader,
BulkTypeConverters,
CamelContextAware {
    private CamelContext camelContext;

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public int size() {
        return 30;
    }

    @Override
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        registry.addBulkTypeConverters(this);
        this.doRegistration(registry);
    }

    @Override
    public <T> T convertTo(Class<?> from, Class<T> to, Exchange exchange, Object value) throws TypeConversionException {
        try {
            Object obj = this.doConvertTo(from, to, exchange, value);
            if (obj == Void.class) {
                return null;
            }
            return (T)obj;
        }
        catch (TypeConversionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TypeConversionException(value, to, e);
        }
    }

    private Object doConvertTo(Class<?> from, Class<?> to, Exchange exchange, Object value) throws Exception {
        if (to == byte[].class) {
            if (value instanceof Buffer) {
                return VertxBufferConverter.toBytes((Buffer)value);
            }
            if (value instanceof JsonArray) {
                return VertxJsonArrayConverter.toBytes((JsonArray)value);
            }
            if (value instanceof JsonObject) {
                return VertxJsonObjectConverter.toBytes((JsonObject)value);
            }
        } else if (to == Buffer.class) {
            if (value instanceof byte[]) {
                return VertxBufferConverter.toBuffer((byte[])value);
            }
            if (value instanceof ByteBuf) {
                return VertxBufferConverter.toBuffer((ByteBuf)value);
            }
            if (value instanceof JsonArray) {
                return VertxJsonArrayConverter.toBuffer((JsonArray)value);
            }
            if (value instanceof JsonObject) {
                return VertxJsonObjectConverter.toBuffer((JsonObject)value);
            }
            if (value instanceof InputStream) {
                return VertxBufferConverter.toBuffer((InputStream)value);
            }
            if (value instanceof String) {
                return VertxBufferConverter.toBuffer((String)value, exchange);
            }
        } else if (to == JsonArray.class) {
            if (value instanceof byte[]) {
                return VertxJsonArrayConverter.toJsonArray((byte[])value);
            }
            if (value instanceof ByteBuf) {
                return VertxJsonArrayConverter.toJsonArray((ByteBuf)value);
            }
            if (value instanceof Buffer) {
                return VertxJsonArrayConverter.toJsonArray((Buffer)value);
            }
            if (value instanceof InputStream) {
                return VertxJsonArrayConverter.toJsonArray((InputStream)value);
            }
            if (value instanceof String) {
                return VertxJsonArrayConverter.toJsonArray((String)value);
            }
            if (value instanceof List) {
                return VertxJsonArrayConverter.toJsonArray((List)value);
            }
        } else if (to == JsonObject.class) {
            if (value instanceof byte[]) {
                return VertxJsonObjectConverter.toJsonObject((byte[])value);
            }
            if (value instanceof ByteBuf) {
                return VertxJsonObjectConverter.toJsonObject((ByteBuf)value);
            }
            if (value instanceof Buffer) {
                return VertxJsonObjectConverter.toJsonObject((Buffer)value);
            }
            if (value instanceof InputStream) {
                return VertxJsonObjectConverter.toJsonObject((InputStream)value);
            }
            if (value instanceof String) {
                return VertxJsonObjectConverter.toJsonObject((String)value);
            }
            if (value instanceof Map) {
                return VertxJsonObjectConverter.toJsonObject((Map)value);
            }
        } else if (to == InputStream.class) {
            if (value instanceof Buffer) {
                return VertxBufferConverter.toInputStream((Buffer)value);
            }
            if (value instanceof JsonArray) {
                return VertxJsonArrayConverter.toInputStream((JsonArray)value);
            }
            if (value instanceof JsonObject) {
                return VertxJsonObjectConverter.toInputStream((JsonObject)value);
            }
        } else if (to == String.class) {
            if (value instanceof Buffer) {
                return VertxBufferConverter.toString((Buffer)value, exchange);
            }
            if (value instanceof JsonArray) {
                return VertxJsonArrayConverter.toString((JsonArray)value);
            }
            if (value instanceof JsonObject) {
                return VertxJsonObjectConverter.toString((JsonObject)value);
            }
        } else if (to == List.class) {
            if (value instanceof JsonArray) {
                return VertxJsonArrayConverter.toList((JsonArray)value);
            }
        } else if (to == Map.class) {
            if (value instanceof JsonObject) {
                return VertxJsonObjectConverter.toMap((JsonObject)value);
            }
        } else if (to == StreamCache.class && value instanceof Buffer) {
            return VertxBufferConverter.toStreamCache((Buffer)value);
        }
        return null;
    }

    private void doRegistration(TypeConverterRegistry registry) {
        registry.addConverter(new TypeConvertible<Buffer, byte[]>(Buffer.class, byte[].class), this);
        registry.addConverter(new TypeConvertible<JsonArray, byte[]>(JsonArray.class, byte[].class), this);
        registry.addConverter(new TypeConvertible<JsonObject, byte[]>(JsonObject.class, byte[].class), this);
        registry.addConverter(new TypeConvertible<byte[], Buffer>(byte[].class, Buffer.class), this);
        registry.addConverter(new TypeConvertible<ByteBuf, Buffer>(ByteBuf.class, Buffer.class), this);
        registry.addConverter(new TypeConvertible<JsonArray, Buffer>(JsonArray.class, Buffer.class), this);
        registry.addConverter(new TypeConvertible<JsonObject, Buffer>(JsonObject.class, Buffer.class), this);
        registry.addConverter(new TypeConvertible<InputStream, Buffer>(InputStream.class, Buffer.class), this);
        registry.addConverter(new TypeConvertible<String, Buffer>(String.class, Buffer.class), this);
        registry.addConverter(new TypeConvertible<byte[], JsonArray>(byte[].class, JsonArray.class), this);
        registry.addConverter(new TypeConvertible<ByteBuf, JsonArray>(ByteBuf.class, JsonArray.class), this);
        registry.addConverter(new TypeConvertible<Buffer, JsonArray>(Buffer.class, JsonArray.class), this);
        registry.addConverter(new TypeConvertible<InputStream, JsonArray>(InputStream.class, JsonArray.class), this);
        registry.addConverter(new TypeConvertible<String, JsonArray>(String.class, JsonArray.class), this);
        registry.addConverter(new TypeConvertible<List, JsonArray>(List.class, JsonArray.class), this);
        registry.addConverter(new TypeConvertible<byte[], JsonObject>(byte[].class, JsonObject.class), this);
        registry.addConverter(new TypeConvertible<ByteBuf, JsonObject>(ByteBuf.class, JsonObject.class), this);
        registry.addConverter(new TypeConvertible<Buffer, JsonObject>(Buffer.class, JsonObject.class), this);
        registry.addConverter(new TypeConvertible<InputStream, JsonObject>(InputStream.class, JsonObject.class), this);
        registry.addConverter(new TypeConvertible<String, JsonObject>(String.class, JsonObject.class), this);
        registry.addConverter(new TypeConvertible<Map, JsonObject>(Map.class, JsonObject.class), this);
        registry.addConverter(new TypeConvertible<Buffer, InputStream>(Buffer.class, InputStream.class), this);
        registry.addConverter(new TypeConvertible<JsonArray, InputStream>(JsonArray.class, InputStream.class), this);
        registry.addConverter(new TypeConvertible<JsonObject, InputStream>(JsonObject.class, InputStream.class), this);
        registry.addConverter(new TypeConvertible<Buffer, String>(Buffer.class, String.class), this);
        registry.addConverter(new TypeConvertible<JsonArray, String>(JsonArray.class, String.class), this);
        registry.addConverter(new TypeConvertible<JsonObject, String>(JsonObject.class, String.class), this);
        registry.addConverter(new TypeConvertible<JsonArray, List>(JsonArray.class, List.class), this);
        registry.addConverter(new TypeConvertible<JsonObject, Map>(JsonObject.class, Map.class), this);
        registry.addConverter(new TypeConvertible<Buffer, StreamCache>(Buffer.class, StreamCache.class), this);
    }

    @Override
    public TypeConverter lookup(Class<?> to, Class<?> from) {
        if (to == byte[].class) {
            if (from == Buffer.class) {
                return this;
            }
            if (from == JsonArray.class) {
                return this;
            }
            if (from == JsonObject.class) {
                return this;
            }
        } else if (to == Buffer.class) {
            if (from == byte[].class) {
                return this;
            }
            if (from == ByteBuf.class) {
                return this;
            }
            if (from == JsonArray.class) {
                return this;
            }
            if (from == JsonObject.class) {
                return this;
            }
            if (from == InputStream.class) {
                return this;
            }
            if (from == String.class) {
                return this;
            }
        } else if (to == JsonArray.class) {
            if (from == byte[].class) {
                return this;
            }
            if (from == ByteBuf.class) {
                return this;
            }
            if (from == Buffer.class) {
                return this;
            }
            if (from == InputStream.class) {
                return this;
            }
            if (from == String.class) {
                return this;
            }
            if (from == List.class) {
                return this;
            }
        } else if (to == JsonObject.class) {
            if (from == byte[].class) {
                return this;
            }
            if (from == ByteBuf.class) {
                return this;
            }
            if (from == Buffer.class) {
                return this;
            }
            if (from == InputStream.class) {
                return this;
            }
            if (from == String.class) {
                return this;
            }
            if (from == Map.class) {
                return this;
            }
        } else if (to == InputStream.class) {
            if (from == Buffer.class) {
                return this;
            }
            if (from == JsonArray.class) {
                return this;
            }
            if (from == JsonObject.class) {
                return this;
            }
        } else if (to == String.class) {
            if (from == Buffer.class) {
                return this;
            }
            if (from == JsonArray.class) {
                return this;
            }
            if (from == JsonObject.class) {
                return this;
            }
        } else if (to == List.class ? from == JsonArray.class : (to == Map.class ? from == JsonObject.class : to == StreamCache.class && from == Buffer.class)) {
            return this;
        }
        return null;
    }
}

