/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx.common;

import io.netty.buffer.ByteBuf;
import io.vertx.core.buffer.Buffer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.StreamCache;
import org.apache.camel.converter.stream.ByteArrayInputStreamCache;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;

@Converter(generateBulkLoader=true)
public final class VertxBufferConverter {
    private VertxBufferConverter() {
    }

    @Converter
    public static Buffer toBuffer(String string, Exchange exchange) {
        String charset = VertxBufferConverter.getCharsetFromExchange(exchange);
        if (ObjectHelper.isNotEmpty(charset)) {
            return Buffer.buffer(string, charset);
        }
        return Buffer.buffer(string);
    }

    @Converter
    public static Buffer toBuffer(byte[] bytes) {
        return Buffer.buffer(bytes);
    }

    @Converter
    public static Buffer toBuffer(ByteBuf byteBuf) {
        return Buffer.buffer(byteBuf);
    }

    @Converter
    public static Buffer toBuffer(InputStream inputStream) throws IOException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            IOHelper.copy(IOHelper.buffered(inputStream), bos);
            Buffer buffer = Buffer.buffer(bos.toByteArray());
            return buffer;
        }
        finally {
            IOHelper.close((Closeable)inputStream);
        }
    }

    @Converter
    public static String toString(Buffer buffer, Exchange exchange) {
        String charset = VertxBufferConverter.getCharsetFromExchange(exchange);
        if (ObjectHelper.isNotEmpty(charset)) {
            return buffer.toString(charset);
        }
        return buffer.toString();
    }

    @Converter
    public static byte[] toBytes(Buffer buffer) {
        return buffer.getBytes();
    }

    @Converter
    public static InputStream toInputStream(Buffer buffer) {
        return new ByteArrayInputStream(buffer.getBytes());
    }

    @Converter
    public static StreamCache toStreamCache(Buffer buffer) {
        return new ByteArrayInputStreamCache(new ByteArrayInputStream(buffer.getBytes()));
    }

    private static String getCharsetFromExchange(Exchange exchange) {
        String charset = null;
        if (exchange != null) {
            String contentType = exchange.getMessage().getHeader("Content-Type", String.class);
            if (contentType != null) {
                charset = IOHelper.getCharsetNameFromContentType(contentType);
            }
            if (ObjectHelper.isEmpty(charset)) {
                charset = exchange.getProperty(ExchangePropertyKey.CHARSET_NAME, String.class);
            }
        }
        return charset;
    }
}

