/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx.common;

import io.netty.buffer.ByteBuf;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.camel.Converter;
import org.apache.camel.util.IOHelper;

@Converter(generateBulkLoader=true)
public final class VertxJsonObjectConverter {
    private VertxJsonObjectConverter() {
    }

    @Converter
    public static JsonObject toJsonObject(Buffer buffer) {
        return new JsonObject(buffer);
    }

    @Converter
    public static JsonObject toJsonObject(String string) {
        return new JsonObject(string);
    }

    @Converter
    public static JsonObject toJsonObject(byte[] bytes) {
        return Buffer.buffer(bytes).toJsonObject();
    }

    @Converter
    public static JsonObject toJsonObject(ByteBuf byteBuf) {
        return Buffer.buffer(byteBuf).toJsonObject();
    }

    @Converter
    public static JsonObject toJsonObject(Map<String, Object> map) {
        return new JsonObject(map);
    }

    @Converter
    public static JsonObject toJsonObject(InputStream inputStream) throws IOException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            IOHelper.copy(IOHelper.buffered(inputStream), bos);
            JsonObject jsonObject = Buffer.buffer(bos.toByteArray()).toJsonObject();
            return jsonObject;
        }
        finally {
            IOHelper.close((Closeable)inputStream);
        }
    }

    @Converter
    public static Buffer toBuffer(JsonObject jsonObject) {
        return jsonObject.toBuffer();
    }

    @Converter
    public static String toString(JsonObject jsonObject) {
        return jsonObject.encode();
    }

    @Converter
    public static byte[] toBytes(JsonObject jsonObject) {
        return jsonObject.toBuffer().getBytes();
    }

    @Converter
    public static Map<String, Object> toMap(JsonObject jsonObject) {
        return jsonObject.getMap();
    }

    @Converter
    public static InputStream toInputStream(JsonObject jsonObject) {
        return new ByteArrayInputStream(jsonObject.toBuffer().getBytes());
    }
}

