/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadRuntimeException;
import org.apache.camel.component.vertx.VertxEndpoint;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.MessageHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertxProducer
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(VertxProducer.class);

    public VertxProducer(VertxEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    public VertxEndpoint getEndpoint() {
        return (VertxEndpoint)super.getEndpoint();
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        EventBus eventBus = this.getEndpoint().getEventBus();
        if (eventBus == null) {
            exchange.setException(new IllegalStateException("EventBus is not started or not configured"));
            callback.done(true);
            return true;
        }
        String address = this.getEndpoint().getAddress();
        boolean reply = ExchangeHelper.isOutCapable(exchange);
        boolean pubSub = this.getEndpoint().isPubSub();
        Object body = exchange.getMessage().getBody();
        if (body != null) {
            if (reply) {
                LOG.debug("Sending to: {} with body: {}", (Object)address, body);
                eventBus.request(address, body, new CamelReplyHandler(exchange, callback));
                return false;
            }
            if (pubSub) {
                LOG.debug("Publishing to: {} with body: {}", (Object)address, body);
                eventBus.publish(address, body);
            } else {
                LOG.debug("Sending to: {} with body: {}", (Object)address, body);
                eventBus.send(address, body);
            }
            callback.done(true);
            return true;
        }
        exchange.setException(new InvalidPayloadRuntimeException(exchange, String.class));
        callback.done(true);
        return true;
    }

    private static final class CamelReplyHandler
    implements Handler<AsyncResult<Message<Object>>> {
        private final Exchange exchange;
        private final AsyncCallback callback;

        private CamelReplyHandler(Exchange exchange, AsyncCallback callback) {
            this.exchange = exchange;
            this.callback = callback;
        }

        @Override
        public void handle(AsyncResult<Message<Object>> event) {
            try {
                MessageHelper.copyHeaders(this.exchange.getIn(), this.exchange.getOut(), false);
                Throwable e = event.cause();
                if (e != null) {
                    this.exchange.setException(e);
                } else {
                    this.exchange.getMessage().setBody(event.result().body());
                }
            }
            finally {
                this.callback.done(false);
            }
        }
    }
}

