/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.runtime;

import com.dylibso.chicory.runtime.Instance;
import com.dylibso.chicory.wasm.exceptions.InvalidException;
import com.dylibso.chicory.wasm.types.Instruction;
import com.dylibso.chicory.wasm.types.MutabilityType;
import com.dylibso.chicory.wasm.types.Value;
import com.dylibso.chicory.wasm.types.ValueType;
import java.util.Arrays;
import java.util.List;

public class ConstantEvaluators {
    public static Value computeConstantValue(Instance instance, Instruction[] expr) {
        return ConstantEvaluators.computeConstantValue(instance, Arrays.asList(expr));
    }

    public static Value computeConstantValue(Instance instance, List<Instruction> expr) {
        Value tos = null;
        block10: for (Instruction instruction : expr) {
            switch (instruction.opcode()) {
                case F32_CONST: {
                    tos = Value.f32(instruction.operands()[0]);
                    continue block10;
                }
                case F64_CONST: {
                    tos = Value.f64(instruction.operands()[0]);
                    continue block10;
                }
                case I32_CONST: {
                    tos = Value.i32(instruction.operands()[0]);
                    continue block10;
                }
                case I64_CONST: {
                    tos = Value.i64(instruction.operands()[0]);
                    continue block10;
                }
                case REF_NULL: {
                    ValueType vt = ValueType.refTypeForId((int)instruction.operands()[0]);
                    if (vt == ValueType.ExternRef) {
                        tos = Value.EXTREF_NULL;
                        continue block10;
                    }
                    if (vt == ValueType.FuncRef) {
                        tos = Value.FUNCREF_NULL;
                        continue block10;
                    }
                    throw new IllegalStateException("Unexpected wrong type for ref.null instruction");
                }
                case REF_FUNC: {
                    int idx = (int)instruction.operands()[0];
                    instance.function(idx);
                    tos = Value.funcRef(idx);
                    continue block10;
                }
                case GLOBAL_GET: {
                    int idx = (int)instruction.operands()[0];
                    if (idx < instance.imports().globalCount()) {
                        if (instance.imports().global(idx).mutabilityType() != MutabilityType.Const) {
                            throw new InvalidException("constant expression required, initializer expression cannot reference a mutable global");
                        }
                        return instance.readGlobal(idx);
                    }
                    throw new InvalidException("unknown global " + idx + ", initializer expression can only reference an imported global");
                }
                case END: {
                    continue block10;
                }
            }
            throw new InvalidException("constant expression required, but non-constant instruction encountered: " + instruction);
        }
        if (tos == null) {
            throw new InvalidException("type mismatch, expected constant value");
        }
        return tos;
    }

    public static Instance computeConstantInstance(Instance instance, List<Instruction> expr) {
        for (Instruction instruction : expr) {
            switch (instruction.opcode()) {
                case GLOBAL_GET: {
                    return instance.global((int)instruction.operands()[0]).getInstance();
                }
            }
        }
        return instance;
    }
}

