/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.runtime;

import com.dylibso.chicory.runtime.FromHost;
import com.dylibso.chicory.runtime.TableInstance;
import com.dylibso.chicory.wasm.types.Limits;
import com.dylibso.chicory.wasm.types.Table;
import com.dylibso.chicory.wasm.types.ValueType;
import java.util.Map;

public class HostTable
implements FromHost {
    private final String moduleName;
    private final String fieldName;
    private final TableInstance table;

    public HostTable(String moduleName, String fieldName, TableInstance table) {
        this.moduleName = moduleName;
        this.fieldName = fieldName;
        this.table = table;
    }

    public HostTable(String moduleName, String fieldName, Map<Integer, Integer> funcRefs) {
        this.moduleName = moduleName;
        this.fieldName = fieldName;
        long maxFuncRef = 0L;
        for (Integer k : funcRefs.keySet()) {
            if ((long)k.intValue() <= maxFuncRef) continue;
            maxFuncRef = k.intValue();
        }
        this.table = new TableInstance(new Table(ValueType.FuncRef, new Limits(maxFuncRef, maxFuncRef)));
        this.table.reset();
    }

    @Override
    public String moduleName() {
        return this.moduleName;
    }

    @Override
    public String fieldName() {
        return this.fieldName;
    }

    @Override
    public FromHost.FromHostType type() {
        return FromHost.FromHostType.TABLE;
    }

    public TableInstance table() {
        return this.table;
    }
}

