/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.runtime;

import com.dylibso.chicory.runtime.ConstantEvaluators;
import com.dylibso.chicory.runtime.ExecutionListener;
import com.dylibso.chicory.runtime.ExportFunction;
import com.dylibso.chicory.runtime.GlobalInstance;
import com.dylibso.chicory.runtime.HostFunction;
import com.dylibso.chicory.runtime.HostImports;
import com.dylibso.chicory.runtime.InterpreterMachine;
import com.dylibso.chicory.runtime.MStack;
import com.dylibso.chicory.runtime.Machine;
import com.dylibso.chicory.runtime.Memory;
import com.dylibso.chicory.runtime.Module;
import com.dylibso.chicory.runtime.TableInstance;
import com.dylibso.chicory.runtime.TrapException;
import com.dylibso.chicory.runtime.TypeValidator;
import com.dylibso.chicory.runtime.exceptions.WASMMachineException;
import com.dylibso.chicory.wasm.exceptions.ChicoryException;
import com.dylibso.chicory.wasm.exceptions.InvalidException;
import com.dylibso.chicory.wasm.exceptions.UninstantiableException;
import com.dylibso.chicory.wasm.types.ActiveDataSegment;
import com.dylibso.chicory.wasm.types.ActiveElement;
import com.dylibso.chicory.wasm.types.DataSegment;
import com.dylibso.chicory.wasm.types.DeclarativeElement;
import com.dylibso.chicory.wasm.types.Element;
import com.dylibso.chicory.wasm.types.Export;
import com.dylibso.chicory.wasm.types.FunctionBody;
import com.dylibso.chicory.wasm.types.FunctionType;
import com.dylibso.chicory.wasm.types.Global;
import com.dylibso.chicory.wasm.types.Instruction;
import com.dylibso.chicory.wasm.types.MutabilityType;
import com.dylibso.chicory.wasm.types.OpCode;
import com.dylibso.chicory.wasm.types.Table;
import com.dylibso.chicory.wasm.types.Value;
import com.dylibso.chicory.wasm.types.ValueType;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

public class Instance {
    private final Module module;
    private final Machine machine;
    private final FunctionBody[] functions;
    private final Memory memory;
    private final DataSegment[] dataSegments;
    private final Global[] globalInitializers;
    private final GlobalInstance[] globals;
    private final int importedGlobalsOffset;
    private final int importedFunctionsOffset;
    private final int importedTablesOffset;
    private final FunctionType[] types;
    private final int[] functionTypes;
    private final HostImports imports;
    private final Table[] roughTables;
    private TableInstance[] tables;
    private final Element[] elements;
    private final boolean start;
    private final boolean typeValidation;
    private final ExecutionListener listener;

    public Instance(Module module, Global[] globalInitializers, int importedGlobalsOffset, int importedFunctionsOffset, int importedTablesOffset, Memory memory, DataSegment[] dataSegments, FunctionBody[] functions, FunctionType[] types, int[] functionTypes, HostImports imports, Table[] tables, Element[] elements, boolean initialize, boolean start, boolean typeValidation) {
        this(module, globalInitializers, importedGlobalsOffset, importedFunctionsOffset, importedTablesOffset, memory, dataSegments, functions, types, functionTypes, imports, tables, elements, InterpreterMachine::new, initialize, start, typeValidation, null);
    }

    public Instance(Module module, Global[] globalInitializers, int importedGlobalsOffset, int importedFunctionsOffset, int importedTablesOffset, Memory memory, DataSegment[] dataSegments, FunctionBody[] functions, FunctionType[] types, int[] functionTypes, HostImports imports, Table[] tables, Element[] elements, Function<Instance, Machine> machineFactory, boolean initialize, boolean start, boolean typeValidation, ExecutionListener listener) {
        this.module = module;
        this.globalInitializers = (Global[])globalInitializers.clone();
        this.globals = new GlobalInstance[globalInitializers.length];
        this.importedGlobalsOffset = importedGlobalsOffset;
        this.importedFunctionsOffset = importedFunctionsOffset;
        this.importedTablesOffset = importedTablesOffset;
        this.memory = memory;
        this.dataSegments = dataSegments;
        this.functions = (FunctionBody[])functions.clone();
        this.types = (FunctionType[])types.clone();
        this.functionTypes = (int[])functionTypes.clone();
        this.imports = imports;
        this.machine = machineFactory.apply(this);
        this.roughTables = (Table[])tables.clone();
        this.elements = (Element[])elements.clone();
        this.start = start;
        this.listener = listener;
        this.typeValidation = typeValidation;
        if (initialize) {
            this.initialize(this.start);
        }
    }

    public Instance initialize(boolean start) {
        int i;
        this.tables = new TableInstance[this.roughTables.length];
        for (int i2 = 0; i2 < this.roughTables.length; ++i2) {
            this.tables[i2] = new TableInstance(this.roughTables[i2]);
        }
        Element[] i2 = this.elements;
        int n = i2.length;
        for (int j = 0; j < n; ++j) {
            Element el = i2[j];
            if (el instanceof ActiveElement) {
                ActiveElement ae = (ActiveElement)el;
                TableInstance table = this.table(ae.tableIndex());
                if (ae.offset().size() > 1) {
                    throw new InvalidException("constant expression required, type mismatch, expected [] but found extra instructions");
                }
                Value offset = ConstantEvaluators.computeConstantValue(this, ae.offset());
                if (offset.type() != ValueType.I32) {
                    throw new InvalidException("type mismatch, invalid offset type in element " + offset.type());
                }
                List<List<Instruction>> initializers = ae.initializers();
                for (int i3 = 0; i3 < initializers.size(); ++i3) {
                    List<Instruction> init = initializers.get(i3);
                    int index = offset.asInt() + i3;
                    if (init.stream().filter(e -> e.opcode() != OpCode.END).count() > 1L) {
                        throw new InvalidException("constant expression required, type mismatch, expected [] but found extra instructions");
                    }
                    Value value = ConstantEvaluators.computeConstantValue(this, init);
                    Instance inst = ConstantEvaluators.computeConstantInstance(this, init);
                    if (value.type() != ae.type() || table.elementType() != ae.type()) {
                        throw new InvalidException("type mismatch, element type: " + ae.type() + ", table type: " + table.elementType() + ", value type: " + value.type());
                    }
                    if (ae.type() == ValueType.FuncRef) {
                        if (value.asFuncRef() != -1) {
                            try {
                                this.function(value.asFuncRef());
                            }
                            catch (InvalidException e2) {
                                throw new InvalidException("type mismatch, " + e2.getMessage(), e2);
                            }
                        }
                        table.setRef(index, value.asFuncRef(), inst);
                        continue;
                    }
                    assert (ae.type() == ValueType.ExternRef);
                    table.setRef(index, value.asExtRef(), inst);
                }
                continue;
            }
            if (!(el instanceof DeclarativeElement)) continue;
            DeclarativeElement de = (DeclarativeElement)el;
            List<List<Instruction>> initializers = de.initializers();
            for (int i4 = 0; i4 < initializers.size(); ++i4) {
                List<Instruction> init = initializers.get(i4);
                Value value = ConstantEvaluators.computeConstantValue(this, init);
                if (de.type() != ValueType.FuncRef || value.asFuncRef() == -1 || value.asFuncRef() < this.importedFunctionsOffset) continue;
                this.function(value.asFuncRef()).setInitializedByElem(true);
            }
        }
        for (i = 0; i < this.globalInitializers.length; ++i) {
            Global g = this.globalInitializers[i];
            if (g.mutabilityType() == MutabilityType.Const && g.initInstructions().size() > 1) {
                throw new InvalidException("constant expression required, type mismatch, expected [] but found extra instructions");
            }
            Value value = ConstantEvaluators.computeConstantValue(this, g.initInstructions());
            if (g.valueType() != value.type()) {
                throw new InvalidException("type mismatch, expected: " + g.valueType() + ", got: " + value.type());
            }
            this.globals[i] = new GlobalInstance(value);
            this.globals[i].setInstance(this);
        }
        if (this.memory != null) {
            this.memory.initialize(this, this.dataSegments);
        } else if (this.imports.memories().length > 0) {
            this.imports.memories()[0].memory().initialize(this, this.dataSegments);
        } else if (Arrays.stream(this.dataSegments).anyMatch(ds -> ds instanceof ActiveDataSegment)) {
            for (DataSegment ds2 : this.dataSegments) {
                if (!(ds2 instanceof ActiveDataSegment)) continue;
                ActiveDataSegment memory = (ActiveDataSegment)ds2;
                throw new InvalidException("unknown memory " + memory.index());
            }
            throw new InvalidException("unknown memory");
        }
        if (this.typeValidation) {
            for (i = 0; i < this.functions.length; ++i) {
                if (this.function(i) == null) continue;
                int funcType = this.functionType(i);
                if (funcType >= this.types.length) {
                    throw new InvalidException("unknown type " + funcType);
                }
                new TypeValidator().validate(i, this.function(i), this.types[funcType], this);
            }
        }
        if (this.module.export("_start") != null && start) {
            this.export("_start").apply(new Value[0]);
        }
        return this;
    }

    public ExportFunction export(String name) {
        final Export export = this.module.export(name);
        if (export == null) {
            throw new ChicoryException("Unknown export with name " + name);
        }
        switch (export.exportType()) {
            case FUNCTION: {
                int funcId = export.index();
                return args -> {
                    this.module.logger().debug(() -> "Args: " + Arrays.toString(args));
                    try {
                        return this.machine.call(funcId, args);
                    }
                    catch (InvalidException e) {
                        throw e;
                    }
                    catch (TrapException e) {
                        throw new UninstantiableException("unreachable", e);
                    }
                    catch (Exception e) {
                        throw new WASMMachineException(this.machine.getStackTrace(), (Throwable)e);
                    }
                };
            }
            case GLOBAL: {
                return new ExportFunction(){

                    @Override
                    public Value[] apply(Value ... args) throws ChicoryException {
                        assert (args.length == 0);
                        return new Value[]{Instance.this.readGlobal(export.index())};
                    }
                };
            }
        }
        throw new ChicoryException("not implemented");
    }

    public FunctionBody function(long idx) {
        if (idx < 0L || idx >= (long)(this.functions.length + this.importedFunctionsOffset)) {
            throw new InvalidException("unknown function " + idx);
        }
        if (idx < (long)this.importedFunctionsOffset) {
            return null;
        }
        return this.functions[(int)idx - this.importedFunctionsOffset];
    }

    public int functionCount() {
        return this.importedFunctionsOffset + this.functions.length;
    }

    public Memory memory() {
        return this.memory;
    }

    public GlobalInstance global(int idx) {
        if (idx < this.importedGlobalsOffset) {
            return this.imports.global(idx).instance();
        }
        return this.globals[idx - this.importedGlobalsOffset];
    }

    public void writeGlobal(int idx, Value val) {
        if (idx < this.importedGlobalsOffset) {
            this.imports.global(idx).instance().setValue(val);
        }
        this.globals[idx - this.importedGlobalsOffset].setValue(val);
    }

    public Value readGlobal(int idx) {
        if (idx < this.importedGlobalsOffset) {
            return this.imports.global(idx).instance().getValue();
        }
        int i = idx - this.importedGlobalsOffset;
        if (i < 0 || i >= this.globals.length) {
            throw new InvalidException("unknown global " + idx);
        }
        return this.globals[idx - this.importedGlobalsOffset].getValue();
    }

    public Global globalInitializer(int idx) {
        if (idx < this.importedGlobalsOffset) {
            return null;
        }
        if (idx - this.importedGlobalsOffset >= this.globalInitializers.length) {
            throw new InvalidException("unknown global " + idx);
        }
        return this.globalInitializers[idx - this.importedGlobalsOffset];
    }

    public int globalCount() {
        return this.globals.length;
    }

    public FunctionType type(int idx) {
        if (idx >= this.types.length) {
            throw new InvalidException("unknown type " + idx);
        }
        return this.types[idx];
    }

    public int typeCount() {
        return this.types.length;
    }

    public int functionType(int idx) {
        if (idx >= this.functionTypes.length) {
            throw new InvalidException("unknown function " + idx);
        }
        return this.functionTypes[idx];
    }

    public HostImports imports() {
        return this.imports;
    }

    public Module module() {
        return this.module;
    }

    public TableInstance table(int idx) {
        if (idx < 0 || idx >= this.tables.length + this.importedTablesOffset) {
            throw new InvalidException("unknown table " + idx);
        }
        if (idx < this.importedTablesOffset) {
            return this.imports.table(idx).table();
        }
        return this.tables[idx - this.importedTablesOffset];
    }

    public DataSegment[] dataSegments() {
        return this.dataSegments;
    }

    public Element element(int idx) {
        if (idx < 0 || idx >= this.elements.length) {
            throw new InvalidException("unknown elem segment " + idx);
        }
        return this.elements[idx];
    }

    public int elementCount() {
        return this.elements.length;
    }

    public void setElement(int idx, Element val) {
        this.elements[idx] = val;
    }

    public Machine getMachine() {
        return this.machine;
    }

    public Value[] callHostFunction(int funcId, Value[] args) {
        HostFunction imprt = this.imports.function(funcId);
        if (imprt == null) {
            throw new ChicoryException("Missing host import, number: " + funcId);
        }
        return imprt.handle().apply(this, args);
    }

    public void onExecution(Instruction instruction, long[] operands, MStack stack) {
        if (this.listener != null) {
            this.listener.onExecution(instruction, operands, stack);
        }
    }
}

