/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.runtime;

import com.dylibso.chicory.runtime.Instance;
import com.dylibso.chicory.runtime.MStack;
import com.dylibso.chicory.wasm.types.Instruction;
import com.dylibso.chicory.wasm.types.NameCustomSection;
import com.dylibso.chicory.wasm.types.Value;
import com.dylibso.chicory.wasm.types.ValueType;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class StackFrame {
    public boolean doControlTransfer = false;
    public boolean isControlFrame = true;
    private final List<Instruction> code;
    private Instruction currentInstruction;
    private final int funcId;
    private int pc;
    private final Value[] locals;
    private final Instance instance;
    private final ArrayDeque<Integer> stackSizeBeforeBlock = new ArrayDeque();

    public StackFrame(Instance instance, int funcId, Value[] args, List<ValueType> localTypes) {
        this(Collections.emptyList(), instance, funcId, args, localTypes);
    }

    public StackFrame(List<Instruction> code, Instance instance, int funcId, Value[] args, List<ValueType> localTypes) {
        this.code = code;
        this.instance = instance;
        this.funcId = funcId;
        this.locals = Arrays.copyOf(args, args.length + localTypes.size());
        for (int i = 0; i < localTypes.size(); ++i) {
            ValueType type = localTypes.get(i);
            if (type == ValueType.V128) continue;
            this.locals[i + args.length] = Value.zero(type);
        }
    }

    void setLocal(int i, Value v) {
        this.locals[i] = v;
    }

    Value local(int i) {
        return this.locals[i];
    }

    public String toString() {
        String funcName;
        NameCustomSection nameSec = this.instance.module().nameSection();
        String id = "[" + this.funcId + "]";
        if (nameSec != null && (funcName = nameSec.nameOfFunction(this.funcId)) != null) {
            id = funcName + id;
        }
        return id + "\n\tpc=" + this.pc + " locals=" + Arrays.toString(this.locals);
    }

    public Instruction loadCurrentInstruction() {
        this.currentInstruction = this.code.get(this.pc++);
        return this.currentInstruction;
    }

    public boolean isLastBlock() {
        return this.currentInstruction.depth() == 0;
    }

    public boolean terminated() {
        return this.pc >= this.code.size();
    }

    public void registerStackSize(MStack stack) {
        this.stackSizeBeforeBlock.push(stack.size());
    }

    public void jumpTo(int newPc) {
        this.pc = newPc;
    }

    public void dropValuesOutOfBlock(MStack stack) {
        if (this.currentInstruction.depth() > 0) {
            while (this.stackSizeBeforeBlock.size() > this.currentInstruction.depth()) {
                this.stackSizeBeforeBlock.pop();
            }
            int expectedStackSize = this.stackSizeBeforeBlock.pop();
            while (stack.size() > expectedStackSize) {
                stack.pop();
            }
        }
    }

    public void endOfNonControlBlock() {
        if (this.currentInstruction.depth() > 0) {
            this.stackSizeBeforeBlock.pop();
        }
    }
}

