/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.runtime;

import com.dylibso.chicory.runtime.Instance;
import com.dylibso.chicory.wasm.exceptions.ChicoryException;
import com.dylibso.chicory.wasm.exceptions.UninstantiableException;
import com.dylibso.chicory.wasm.types.Limits;
import com.dylibso.chicory.wasm.types.Table;
import com.dylibso.chicory.wasm.types.Value;
import com.dylibso.chicory.wasm.types.ValueType;
import java.util.Arrays;

public class TableInstance {
    private Table table;
    private Instance[] instances;
    private int[] refs;

    public TableInstance(Table table) {
        this.table = table;
        this.instances = new Instance[(int)table.limits().min()];
        this.refs = new int[(int)table.limits().min()];
        Arrays.fill(this.refs, -1);
    }

    public int size() {
        return this.refs.length;
    }

    public ValueType elementType() {
        return this.table.elementType();
    }

    public Limits limits() {
        return this.table.limits();
    }

    public int grow(int size, int value, Instance instance) {
        int oldSize = this.refs.length;
        int targetSize = oldSize + size;
        if (size < 0 || (long)targetSize > this.limits().max()) {
            return -1;
        }
        int[] newRefs = Arrays.copyOf(this.refs, targetSize);
        Arrays.fill(newRefs, oldSize, targetSize, value);
        Object[] newInstances = Arrays.copyOf(this.instances, targetSize);
        Arrays.fill(newInstances, oldSize, targetSize, instance);
        this.refs = newRefs;
        this.instances = newInstances;
        return oldSize;
    }

    public Value ref(int index) {
        int res;
        try {
            res = this.refs[index];
        }
        catch (IndexOutOfBoundsException e) {
            throw new ChicoryException("undefined element", e);
        }
        if (this.elementType() == ValueType.FuncRef) {
            return Value.funcRef(res);
        }
        return Value.externRef(res);
    }

    public void setRef(int index, int value, Instance instance) {
        try {
            this.refs[index] = value;
            this.instances[index] = instance;
        }
        catch (IndexOutOfBoundsException e) {
            throw new UninstantiableException("out of bounds table access", e);
        }
    }

    public Instance instance(int index) {
        return this.instances[index];
    }

    public void setRef(int index, int value) {
        try {
            this.refs[index] = value;
        }
        catch (IndexOutOfBoundsException e) {
            throw new UninstantiableException("out of bounds table access", e);
        }
    }

    public void reset() {
        for (int i = 0; i < this.refs.length; ++i) {
            this.refs[i] = -1;
        }
    }
}

