/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.weather;

import org.apache.camel.Exchange;
import org.apache.camel.component.weather.WeatherEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeatherProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(WeatherProducer.class);
    private final String query;

    public WeatherProducer(WeatherEndpoint endpoint, String query) {
        super(endpoint);
        this.query = query;
    }

    @Override
    public WeatherEndpoint getEndpoint() {
        return (WeatherEndpoint)super.getEndpoint();
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        String q = this.query;
        String location = exchange.getIn().getHeader("CamelWeatherLocation", String.class);
        if (location != null) {
            q = this.getEndpoint().getWeatherQuery().getQuery(location);
        }
        CloseableHttpClient httpClient = this.getEndpoint().getConfiguration().getHttpClient();
        String uri = q;
        HttpGet method = new HttpGet(uri);
        httpClient.execute((ClassicHttpRequest)method, response -> {
            try {
                LOG.debug("Going to execute the Weather query {}", (Object)uri);
                if (200 != response.getCode()) {
                    throw new IllegalStateException("Got the invalid http status value '" + response.getCode() + "' as the result of the query '" + this.query + "'");
                }
                String weather = EntityUtils.toString(response.getEntity(), "UTF-8");
                LOG.debug("Got back the Weather information {}", (Object)weather);
                if (ObjectHelper.isEmpty(weather)) {
                    throw new IllegalStateException("Got the unexpected value '" + weather + "' as the result of the query '" + uri + "'");
                }
                String header = this.getEndpoint().getConfiguration().getHeaderName();
                if (header != null) {
                    exchange.getIn().setHeader(header, weather);
                } else {
                    exchange.getIn().setBody(weather);
                }
                exchange.getIn().setHeader("CamelWeatherQuery", uri);
                Object var7_7 = null;
                return var7_7;
            }
            finally {
                method.reset();
            }
        });
    }
}

