/*
 * Decompiled with CFR 0.152.
 */
package jakarta.xml.bind.annotation.adapters;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;

public class CollapsedStringAdapter
extends XmlAdapter<String, String> {
    @Override
    public String unmarshal(String text) {
        int s;
        if (text == null) {
            return null;
        }
        int len = text.length();
        for (s = 0; s < len && !CollapsedStringAdapter.isWhiteSpace(text.charAt(s)); ++s) {
        }
        if (s == len) {
            return text;
        }
        StringBuilder result2 = new StringBuilder(len);
        if (s != 0) {
            for (int i = 0; i < s; ++i) {
                result2.append(text.charAt(i));
            }
            result2.append(' ');
        }
        boolean inStripMode = true;
        for (int i = s + 1; i < len; ++i) {
            char ch = text.charAt(i);
            boolean b = CollapsedStringAdapter.isWhiteSpace(ch);
            if (inStripMode && b) continue;
            inStripMode = b;
            if (inStripMode) {
                result2.append(' ');
                continue;
            }
            result2.append(ch);
        }
        len = result2.length();
        if (len > 0 && result2.charAt(len - 1) == ' ') {
            result2.setLength(len - 1);
        }
        return result2.toString();
    }

    @Override
    public String marshal(String s) {
        return s;
    }

    protected static boolean isWhiteSpace(char ch) {
        if (ch > ' ') {
            return false;
        }
        return ch == '\t' || ch == '\n' || ch == '\r' || ch == ' ';
    }
}

