/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel;

import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;

public class NoSuchPropertyException
extends CamelExchangeException {
    private final String propertyName;
    private final transient Class<?> type;

    public NoSuchPropertyException(Exchange exchange, String propertyName) {
        this(exchange, propertyName, null);
    }

    public NoSuchPropertyException(Exchange exchange, String propertyName, Class<?> type2) {
        super("No '" + propertyName + "' exchange property available" + (String)(type2 != null ? " of type: " + type2.getName() : "") + NoSuchPropertyException.reason(exchange, propertyName), exchange);
        this.propertyName = propertyName;
        this.type = type2;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Class<?> getType() {
        return this.type;
    }

    protected static String reason(Exchange exchange, String propertyName) {
        Object value = exchange.getProperty(propertyName);
        return NoSuchPropertyException.valueDescription(value);
    }

    static String valueDescription(Object value) {
        if (value == null) {
            return "";
        }
        return " but has type: " + value.getClass().getCanonicalName();
    }
}

