/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.saga;

import java.util.Map;
import java.util.Optional;
import org.apache.camel.Endpoint;
import org.apache.camel.Expression;

public class CamelSagaStep {
    private final Endpoint compensation;
    private final Endpoint completion;
    private final Map<String, Expression> options;
    private final Long timeoutInMilliseconds;

    public CamelSagaStep(Endpoint compensation, Endpoint completion, Map<String, Expression> options2, Long timeoutInMilliseconds) {
        this.compensation = compensation;
        this.completion = completion;
        this.options = options2;
        this.timeoutInMilliseconds = timeoutInMilliseconds;
    }

    public Optional<Endpoint> getCompensation() {
        return Optional.ofNullable(this.compensation);
    }

    public Optional<Endpoint> getCompletion() {
        return Optional.ofNullable(this.completion);
    }

    public Map<String, Expression> getOptions() {
        return this.options;
    }

    public Optional<Long> getTimeoutInMilliseconds() {
        return Optional.ofNullable(this.timeoutInMilliseconds);
    }

    public boolean isEmpty() {
        return this.compensation == null && this.completion == null && this.options.isEmpty() && this.timeoutInMilliseconds == null;
    }
}

