/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import org.apache.camel.Exchange;
import org.apache.camel.TypeConverter;
import org.apache.camel.util.IOHelper;

public final class IteratorConvertTo
implements Iterator<Object>,
Closeable {
    private final Exchange exchange;
    private final TypeConverter converter;
    private final Iterator<?> it;
    private final Class<?> type;
    private boolean closed;

    public IteratorConvertTo(Exchange exchange, Iterator<?> it, Class<?> type2) {
        this.exchange = exchange;
        this.converter = exchange.getContext().getTypeConverter();
        this.it = it;
        this.type = type2;
    }

    @Override
    public void close() throws IOException {
        try {
            IOHelper.closeIterator(this.it);
        }
        finally {
            this.closed = true;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.closed) {
            return false;
        }
        boolean answer = this.it.hasNext();
        if (!answer) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return answer;
    }

    @Override
    public Object next() {
        Object next = this.it.next();
        if (next != null) {
            next = this.converter.convertTo(this.type, this.exchange, next);
        }
        return next;
    }

    @Override
    public void remove() {
        this.it.remove();
    }
}

